/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.mixin.client;

import dev.felnull.otyacraftengine.client.debug.HighlightVoxelShapeType;
import dev.felnull.otyacraftengine.client.debug.OtyacraftEngineClientDebug;
import dev.felnull.otyacraftengine.client.shape.ClientIVShapeManager;
import dev.felnull.otyacraftengine.client.shape.VoxelClientShape;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.shape.RotateAngledAxis;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import dev.felnull.otyacraftengine.shape.VoxelEntry;
import dev.felnull.otyacraftengine.shape.VoxelPose;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private class_638 field_4085;

    @Inject(method={"renderHitOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHitOutline(class_4587 poseStack, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 blockPos, class_2680 blockState, CallbackInfo ci) {
        HighlightVoxelShapeType shapeType = OtyacraftEngineClientDebug.getInstance().getHighlightVoxelShape();
        if (shapeType != HighlightVoxelShapeType.OFF) {
            HighlightVoxelShapeType.HighlightVoxelShapeGetter shape = shapeType.getGetter();
            if (shape != null) {
                class_761.method_22983((class_4587)poseStack, (class_4588)vertexConsumer, (class_265)shape.getShape(blockState, (class_1922)this.field_4085, blockPos, class_3726.method_16195((class_1297)entity)), (double)((double)blockPos.method_10263() - d), (double)((double)blockPos.method_10264() - e), (double)((double)blockPos.method_10260() - f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (boolean)true);
            }
            ci.cancel();
        }
    }

    @Inject(method={"renderShape"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderShape(class_4587 poseStack, class_4588 vertexConsumer, class_265 voxelShape, double x, double y, double z, float r, float g, float b, float a, CallbackInfo ci) {
        if (((IkisugiVoxelShape)voxelShape).getRenderEdges() == null) {
            return;
        }
        ci.cancel();
        for (VoxelEntry entry : ((IkisugiVoxelShape)voxelShape).getRenderEdges()) {
            VoxelClientShape cls = ClientIVShapeManager.getInstance().getVoxelClientShape(entry.getLocation());
            if (cls == null) continue;
            poseStack.method_22903();
            VoxelPose p = entry.getPose();
            class_4587.class_4665 pose = poseStack.method_23760();
            VoxelEdge[] cache = cls.getEdgeCache(entry);
            if (cache == null) {
                ArrayList<VoxelEdge> edges = new ArrayList<VoxelEdge>();
                for (VoxelEdge edge : cls.getRenderEdges()) {
                    for (RotateAngledAxis axi : p.axis()) {
                        edge = axi.rotationEdge(edge);
                    }
                    edges.add(edge);
                }
                cache = edges.toArray(new VoxelEdge[0]);
                cls.setEdgeCache(entry, cache);
            }
            for (VoxelEdge edge : cache) {
                LevelRendererMixin.renderShapeEdge(pose, vertexConsumer, edge.stX(), edge.stY(), edge.stZ(), edge.enX(), edge.enY(), edge.enZ(), x, y, z, r, g, b, a);
            }
            poseStack.method_22909();
        }
    }

    private static void renderShapeEdge(class_4587.class_4665 pose, class_4588 vertexConsumer, double sx, double sy, double sz, double ex, double ey, double ez, double x, double y, double z, float r, float g, float b, float a) {
        float q = (float)(ex - sx);
        float r2 = (float)(ey - sy);
        float s = (float)(ez - sz);
        float t = class_3532.method_15355((float)(q * q + r2 * r2 + s * s));
        vertexConsumer.method_22918(pose.method_23761(), (float)(sx + x), (float)(sy + y), (float)(sz + z)).method_22915(r, g, b, a).method_23763(pose.method_23762(), q /= t, r2 /= t, s /= t).method_1344();
        vertexConsumer.method_22918(pose.method_23761(), (float)(ex + x), (float)(ey + y), (float)(ez + z)).method_22915(r, g, b, a).method_23763(pose.method_23762(), q, r2, s).method_1344();
    }
}

