package dev.felnull.specialmodelloader.api;

import dev.felnull.specialmodelloader.api.model.SpecialBaseLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelLoader;
import dev.felnull.specialmodelloader.impl.SpecialModelLoaderAPIImpl;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

import java.util.List;

public interface SpecialModelLoaderAPI {
    static SpecialModelLoaderAPI getInstance() {
        return SpecialModelLoaderAPIImpl.INSTANCE;
    }

    @Unmodifiable @NotNull List<SpecialBaseLoader> getLoaders();

    @NotNull ObjModelLoader getObjLoader();

    @Nullable class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 modelLocation) throws ModelProviderException;
}
