package dev.felnull.specialmodelloader.api.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4941;

public final class SpecialModelDataGenHelper {
    private static final class_2960 OBJ_LOADER = new class_2960(SpecialModelLoader.MODID, "builtin/obj");

    public static void generateObjModel(@NotNull class_2960 location, @NotNull class_2960 objLocation, boolean flipV, boolean useAmbientOcclusion, @Nullable class_2960 particle, @NotNull BiConsumer<class_2960, Supplier<JsonElement>> output) {
        output.accept(location, () -> {
            var jo = new JsonObject();
            jo.addProperty("parent", OBJ_LOADER.toString());
            jo.addProperty("model", objLocation.toString());
            jo.addProperty("flip_v", flipV);
            jo.addProperty("ambientocclusion", useAmbientOcclusion);

            if (particle != null)
                jo.addProperty("particle", particle.toString());

            return jo;
        });
    }

    public static void generateObjModel(@NotNull class_1792 item, @NotNull class_2960 objLocation, boolean flipV, boolean useAmbientOcclusion, @Nullable class_2960 particle, @NotNull BiConsumer<class_2960, Supplier<JsonElement>> output) {
        generateObjModel(class_4941.method_25840(item), objLocation, flipV, useAmbientOcclusion, particle, output);
    }

    public static void generateObjModel(@NotNull class_2248 block, @NotNull class_2960 objLocation, boolean flipV, boolean useAmbientOcclusion, @Nullable class_2960 particle, @NotNull BiConsumer<class_2960, Supplier<JsonElement>> output) {
        generateObjModel(class_4941.method_25842(block), objLocation, flipV, useAmbientOcclusion, particle, output);
    }
}