package dev.felnull.specialmodelloader.impl;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.SpecialModelLoaderAPI;
import dev.felnull.specialmodelloader.api.model.SpecialBaseLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelLoader;
import dev.felnull.specialmodelloader.impl.model.ForgeObjModelCompat;
import dev.felnull.specialmodelloader.impl.model.obj.ObjModelLoaderImp;
import dev.felnull.specialmodelloader.impl.util.JsonModelUtils;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.*;

public class SpecialModelLoaderAPIImpl implements SpecialModelLoaderAPI {
    public static final SpecialModelLoaderAPIImpl INSTANCE = new SpecialModelLoaderAPIImpl();
    private final ObjModelLoader objLoader = new ObjModelLoaderImp();
    private final List<SpecialBaseLoader> loaders = ImmutableList.of(objLoader);

    @Override
    public @NotNull ObjModelLoader getObjLoader() {
        return objLoader;
    }

    @Override
    public @Unmodifiable @NotNull List<SpecialBaseLoader> getLoaders() {
        return loaders;
    }

    @Override
    public @Nullable class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 modelLocation) throws ModelProviderException {
        List<JsonObject> models = new ArrayList<>();
        JsonObject jo = readJson(resourceManager, modelLocation);

        var forgeModel = ForgeObjModelCompat.getObjModelData(jo);
        if (forgeModel != null)
            return getObjLoader().loadModel(resourceManager, forgeModel.getLeft(), forgeModel.getRight());

        class_2960 location = JsonModelUtils.getParentLocation(jo);
        Set<class_2960> aly = new HashSet<>();

        while (location != null) {
            models.add(jo);

            if (aly.contains(location)) {
                SpecialModelLoader.LOGGER.warn("Model parent specification is looping: '{}', '{}'", modelLocation, location);
                return null;
            }

            aly.add(location);

            var loader = getLoader(location);
            if (loader != null) {
                JsonObject ret = new JsonObject();
                Collections.reverse(models);
                models.forEach(r -> r.asMap().forEach((name, rlm) -> ret.add(name, rlm.deepCopy())));
                return loader.loadModel(resourceManager, ret);
            }

            jo = readJson(resourceManager, location);
            location = JsonModelUtils.getParentLocation(jo);
        }

        return null;
    }

    private SpecialBaseLoader getLoader(class_2960 location) {
        return getLoaders().stream()
                .filter(r -> r.isUse(location))
                .limit(1)
                .findFirst()
                .orElse(null);
    }

    private JsonObject readJson(class_3300 resourceManager, class_2960 modelLocation) throws ModelProviderException {
        class_2960 modelPath = new class_2960(modelLocation.method_12836(), "models/" + modelLocation.method_12832() + ".json");
        var res = resourceManager.method_14486(modelPath);
        if (res.isEmpty()) return null;
        JsonObject jo;
        try (var reader = res.get().method_43039()) {
            jo = class_3518.method_15255(reader);
        } catch (IOException ex) {
            throw new ModelProviderException("Failed to load json: " + modelLocation, ex);
        }
        return jo;
    }
}
