package dev.felnull.specialmodelloader.impl.model;

import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public final class ForgeObjModelCompat {
    private static final class_2960 FORGE_OBJ = new class_2960("forge", "obj");

    public static Pair<class_2960, ObjModelOption> getObjModelData(JsonObject modelJson) {
        if (modelJson == null)
            return null;

        if (!modelJson.has("loader") || !modelJson.get("loader").isJsonPrimitive() || !modelJson.getAsJsonPrimitive("loader").isString() || !FORGE_OBJ.toString().equals(modelJson.get("loader").getAsString()))
            return null;

        var model = new class_2960(modelJson.get("model").getAsString());
        return Pair.of(model, ObjModelOption.parse(modelJson));
    }
}
