package dev.felnull.specialmodelloader.impl.model.obj;

import com.google.gson.JsonObject;
import de.javagl.obj.Mtl;
import de.javagl.obj.MtlReader;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjReader;
import de.javagl.obj.ObjUtils;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ObjModelLoaderImp implements ObjModelLoader {

    @Override
    public @Nullable class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull JsonObject modelJson) throws ModelProviderException {
        if (!modelJson.has("model") || !modelJson.get("model").isJsonPrimitive() || !modelJson.getAsJsonPrimitive("model").isString())
            return null;

        var modelLocation = new class_2960(modelJson.get("model").getAsString());
        return loadModel(resourceManager, modelLocation, ObjModelOption.parse(modelJson));
    }

    @Override
    public @Nullable class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 location, @NotNull ObjModelOption option) throws ModelProviderException {
        var res = resourceManager.method_14486(location);
        if (res.isEmpty())
            return null;

        try (var reader = res.get().method_43039()) {
            var obj = ObjUtils.convertToRenderable(ObjReader.read(reader));

            String[] paths = location.method_12832().split("/");
            paths = ArrayUtils.remove(paths, paths.length - 1);
            var loc = new class_2960(location.method_12836(), String.join("/", paths));

            return new ObjUnbakedModelModel(obj, loadMtl(resourceManager, loc, obj.getMtlFileNames()), option);
        } catch (IOException e) {
            throw new ModelProviderException("Failed to load obj file", e);
        }
    }

    private Map<String, Mtl> loadMtl(class_3300 resourceManager, class_2960 location, List<String> mtlNames) {
        return mtlNames.stream().flatMap(r -> loadMtl(resourceManager, location, r).stream()).collect(Collectors.toMap(Mtl::getName, r -> r));
    }

    private List<Mtl> loadMtl(class_3300 resourceManager, class_2960 location, String mtlName) {
        var loc = new class_2960(location.method_12836(), location.method_12832() + "/" + mtlName);
        return resourceManager.method_14486(loc).map(res -> {
            try (var reader = res.method_43039()) {
                return MtlReader.read(reader);
            } catch (IOException e) {
                SpecialModelLoader.LOGGER.error("Failed to read mtl file.", e);
                return new ArrayList<Mtl>();
            }
        }).orElseGet(List::of);
    }

    @Override
    public String getId() {
        return "obj";
    }
}
