package dev.felnull.specialmodelloader.impl.model.obj;

import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.model.ModelOption;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_793;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ObjModelOptionImpl(ModelOption modelOption, boolean flipV) implements ObjModelOption {

    public static ObjModelOptionImpl parse(JsonObject modelJson) {
        return new ObjModelOptionImpl(ModelOption.parse(modelJson), class_3518.method_15258(modelJson, "flip_v", false));
    }

    @Override
    public boolean isFlipV() {
        return flipV;
    }

    @Override
    public boolean isUseAmbientOcclusion() {
        return modelOption.isUseAmbientOcclusion();
    }

    @Override
    public @Nullable class_793.class_4751 getGuiLight() {
        return modelOption.getGuiLight();
    }

    @Override
    public @Nullable class_2960 getParticle() {
        return modelOption.getParticle();
    }

    @Override
    public @NotNull class_809 getTransforms() {
        return modelOption.getTransforms();
    }
}
