package dev.felnull.specialmodelloader.impl.model.obj;

import de.javagl.obj.FloatTuple;
import de.javagl.obj.Mtl;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjFace;
import de.javagl.obj.ObjSplitting;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.model.SimpleMeshModel;
import dev.felnull.specialmodelloader.impl.model.SpecialBaseUnbakedModel;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.client.resources.model.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ObjUnbakedModelModel extends SpecialBaseUnbakedModel {
    private final Obj obj;
    private final Map<String, Mtl> mtl;
    private final ObjModelOption option;

    public ObjUnbakedModelModel(Obj obj, Map<String, Mtl> mtl, ObjModelOption option) {
        super(option);
        this.obj = obj;
        this.mtl = mtl;
        this.option = option;
    }

    @Override
    public Collection<class_2960> method_4755() {
        return List.of();
    }

    @Override
    public void method_45785(Function<class_2960, class_1100> function) {
    }

    @Nullable
    @Override
    public class_1087 method_4753(class_7775 modelBaker, Function<class_4730, class_1058> textureGetter, class_3665 modelState, class_2960 resourceLocation) {
        final Renderer renderer = RendererAccess.INSTANCE.getRenderer() != null ? RendererAccess.INSTANCE.getRenderer() : IndigoRenderer.INSTANCE;

        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();

        Map<String, Obj> materialGroups = ObjSplitting.splitByMaterialGroups(obj);

        materialGroups.forEach((name, model) -> {
            for (int i = 0; i < model.getNumFaces(); i++) {
                emitFace(emitter, modelState, textureGetter, name, model, model.getFace(i));
            }
        });
        return new SimpleMeshModel(getModelOption().isUseAmbientOcclusion(), getGuiLight().method_24299(), textureGetter.apply(getParticleLocation()), getModelOption().getTransforms(), builder.build());
    }

    private void emitFace(QuadEmitter emitter, class_3665 modelState, Function<class_4730, class_1058> textureGetter, String materialName, Obj fObj, ObjFace face) {
        for (int i = 0; i < face.getNumVertices(); i++) {
            emitVertex(i, i, emitter, modelState, fObj, face);
        }

        if (face.getNumVertices() == 3)
            emitVertex(3, 2, emitter, modelState, fObj, face);

        var smtl = mtl.get(materialName);

        int flg = MutableQuadView.BAKE_NORMALIZED;

        if (option.isFlipV())
            flg |= MutableQuadView.BAKE_FLIP_V;

        if (modelState.method_3512())
            flg |= MutableQuadView.BAKE_LOCK_UV;

        if (smtl != null && smtl.getMapKd() != null) {
            emitter.spriteBake(0, textureGetter.apply(new class_4730(class_1723.field_21668, new class_2960(smtl.getMapKd()))), flg);
        } else {
            emitter.spriteBake(0, textureGetter.apply(MISSING), flg);
        }

        emitter.spriteColor(0, -1, -1, -1, -1);

        emitter.emit();
    }

    private void emitVertex(int index, int vertexNum, QuadEmitter emitter, class_3665 modelState, Obj fObj, ObjFace face) {
        var vt = fObj.getVertex(face.getVertexIndex(vertexNum));
        var vertex = new Vector3f(vt.getX(), vt.getY(), vt.getZ());

        vertex.add(-0.5f, -0.5f, -0.5f);
        vertex.rotate(modelState.method_3509().method_22937());
        vertex.add(0.5f, 0.5f, 0.5f);

        var normal = fObj.getNormal(face.getNormalIndex(vertexNum));
        var tex = fObj.getTexCoord(face.getTexCoordIndex(vertexNum));

        emitter.pos(index, vertex.x(), vertex.y(), vertex.z())
                .normal(index, normal.getX(), normal.getY(), normal.getZ())
                .sprite(index, 0, new class_241(tex.getX(), tex.getY()));
    }

}
