/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.specialmodelloader.impl;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.SpecialModelLoaderAPI;
import dev.felnull.specialmodelloader.api.model.SpecialBaseLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import dev.felnull.specialmodelloader.impl.model.ForgeObjModelCompat;
import dev.felnull.specialmodelloader.impl.model.obj.ObjModelLoaderImp;
import dev.felnull.specialmodelloader.impl.util.JsonModelUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SpecialModelLoaderAPIImpl
implements SpecialModelLoaderAPI {
    public static final SpecialModelLoaderAPIImpl INSTANCE = new SpecialModelLoaderAPIImpl();
    private final ObjModelLoader objLoader = new ObjModelLoaderImp();
    private final List<SpecialBaseLoader> loaders = ImmutableList.of((Object)this.objLoader);

    @Override
    @NotNull
    public ObjModelLoader getObjLoader() {
        return this.objLoader;
    }

    @Override
    public @Unmodifiable @NotNull List<SpecialBaseLoader> getLoaders() {
        return this.loaders;
    }

    @Override
    @Nullable
    public class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 modelLocation) throws ModelProviderException {
        ArrayList<JsonObject> models = new ArrayList<JsonObject>();
        JsonObject jo = this.readJson(resourceManager, modelLocation);
        Pair<class_2960, ObjModelOption> forgeModel = ForgeObjModelCompat.getObjModelData(jo);
        if (forgeModel != null) {
            return this.getObjLoader().loadModel(resourceManager, (class_2960)forgeModel.getLeft(), (ObjModelOption)forgeModel.getRight());
        }
        class_2960 location = JsonModelUtils.getParentLocation(jo);
        HashSet<class_2960> aly = new HashSet<class_2960>();
        while (location != null) {
            models.add(jo);
            if (aly.contains(location)) {
                SpecialModelLoader.LOGGER.warn("Model parent specification is looping: '{}', '{}'", (Object)modelLocation, (Object)location);
                return null;
            }
            aly.add(location);
            SpecialBaseLoader loader = this.getLoader(location);
            if (loader != null) {
                JsonObject ret = new JsonObject();
                Collections.reverse(models);
                models.forEach(r -> r.asMap().forEach((name, rlm) -> ret.add(name, rlm.deepCopy())));
                return loader.loadModel(resourceManager, ret);
            }
            jo = this.readJson(resourceManager, location);
            location = JsonModelUtils.getParentLocation(jo);
        }
        return null;
    }

    private SpecialBaseLoader getLoader(class_2960 location) {
        return this.getLoaders().stream().filter(r -> r.isUse(location)).limit(1L).findFirst().orElse(null);
    }

    private JsonObject readJson(class_3300 resourceManager, class_2960 modelLocation) throws ModelProviderException {
        JsonObject jo;
        class_2960 modelPath = new class_2960(modelLocation.method_12836(), "models/" + modelLocation.method_12832() + ".json");
        Optional res = resourceManager.method_14486(modelPath);
        if (res.isEmpty()) {
            return null;
        }
        try (BufferedReader reader = ((class_3298)res.get()).method_43039();){
            jo = class_3518.method_15255((Reader)reader);
        }
        catch (IOException ex) {
            throw new ModelProviderException("Failed to load json: " + modelLocation, (Throwable)ex);
        }
        return jo;
    }
}

