/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.specialmodelloader.impl.model.obj;

import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.Mtl;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.MtlReader;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.Obj;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.ObjReader;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.ObjUtils;
import dev.felnull.specialmodelloader.impl.model.obj.ObjUnbakedModelModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjModelLoaderImp
implements ObjModelLoader {
    @Override
    @Nullable
    public class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull JsonObject modelJson) throws ModelProviderException {
        if (!(modelJson.has("model") && modelJson.get("model").isJsonPrimitive() && modelJson.getAsJsonPrimitive("model").isString())) {
            return null;
        }
        class_2960 modelLocation = new class_2960(modelJson.get("model").getAsString());
        return this.loadModel(resourceManager, modelLocation, ObjModelOption.parse(modelJson));
    }

    @Override
    @Nullable
    public class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull class_2960 location, @NotNull ObjModelOption option) throws ModelProviderException {
        ObjUnbakedModelModel objUnbakedModelModel;
        block9: {
            Optional res = resourceManager.method_14486(location);
            if (res.isEmpty()) {
                return null;
            }
            BufferedReader reader = ((class_3298)res.get()).method_43039();
            try {
                Obj obj = ObjUtils.convertToRenderable(ObjReader.read(reader));
                Object[] paths = location.method_12832().split("/");
                paths = (String[])ArrayUtils.remove((Object[])paths, (int)(paths.length - 1));
                class_2960 loc = new class_2960(location.method_12836(), String.join((CharSequence)"/", (CharSequence[])paths));
                objUnbakedModelModel = new ObjUnbakedModelModel(obj, this.loadMtl(resourceManager, loc, obj.getMtlFileNames()), option);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ModelProviderException("Failed to load obj file", (Throwable)e);
                }
            }
            reader.close();
        }
        return objUnbakedModelModel;
    }

    private Map<String, Mtl> loadMtl(class_3300 resourceManager, class_2960 location, List<String> mtlNames) {
        return mtlNames.stream().flatMap(r -> this.loadMtl(resourceManager, location, (String)r).stream()).collect(Collectors.toMap(Mtl::getName, r -> r));
    }

    private List<Mtl> loadMtl(class_3300 resourceManager, class_2960 location, String mtlName) {
        class_2960 loc = new class_2960(location.method_12836(), location.method_12832() + "/" + mtlName);
        return resourceManager.method_14486(loc).map(res -> {
            List<Mtl> list;
            block8: {
                BufferedReader reader = res.method_43039();
                try {
                    list = MtlReader.read(reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        SpecialModelLoader.LOGGER.error("Failed to read mtl file.", (Throwable)e);
                        return new ArrayList();
                    }
                }
                reader.close();
            }
            return list;
        }).orElseGet(List::of);
    }

    @Override
    public String getId() {
        return "obj";
    }
}

