/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.specialmodelloader.impl.model.obj;

import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.FloatTuple;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.Mtl;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.Obj;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.ObjFace;
import dev.felnull.specialmodelloader.impl.include.de.javagl.obj.ObjSplitting;
import dev.felnull.specialmodelloader.impl.model.SimpleMeshModel;
import dev.felnull.specialmodelloader.impl.model.SpecialBaseUnbakedModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ObjUnbakedModelModel
extends SpecialBaseUnbakedModel {
    private final Obj obj;
    private final Map<String, Mtl> mtl;
    private final ObjModelOption option;

    public ObjUnbakedModelModel(Obj obj, Map<String, Mtl> mtl, ObjModelOption option) {
        super(option);
        this.obj = obj;
        this.mtl = mtl;
        this.option = option;
    }

    public Collection<class_2960> method_4755() {
        return List.of();
    }

    public void method_45785(Function<class_2960, class_1100> function) {
    }

    @Nullable
    public class_1087 method_4753(class_7775 modelBaker, Function<class_4730, class_1058> textureGetter, class_3665 modelState, class_2960 resourceLocation) {
        IndigoRenderer renderer = RendererAccess.INSTANCE.getRenderer() != null ? RendererAccess.INSTANCE.getRenderer() : IndigoRenderer.INSTANCE;
        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        Map<String, Obj> materialGroups = ObjSplitting.splitByMaterialGroups(this.obj);
        materialGroups.forEach((name, model) -> {
            for (int i = 0; i < model.getNumFaces(); ++i) {
                this.emitFace(emitter, modelState, textureGetter, (String)name, (Obj)model, model.getFace(i));
            }
        });
        return new SimpleMeshModel(this.getModelOption().isUseAmbientOcclusion(), this.getGuiLight().method_24299(), textureGetter.apply(this.getParticleLocation()), this.getModelOption().getTransforms(), builder.build());
    }

    private void emitFace(QuadEmitter emitter, class_3665 modelState, Function<class_4730, class_1058> textureGetter, String materialName, Obj fObj, ObjFace face) {
        for (int i = 0; i < face.getNumVertices(); ++i) {
            this.emitVertex(i, i, emitter, modelState, fObj, face);
        }
        if (face.getNumVertices() == 3) {
            this.emitVertex(3, 2, emitter, modelState, fObj, face);
        }
        Mtl smtl = this.mtl.get(materialName);
        int flg = 32;
        if (this.option.isFlipV()) {
            flg |= 0x10;
        }
        if (modelState.method_3512()) {
            flg |= 4;
        }
        if (smtl != null && smtl.getMapKd() != null) {
            emitter.spriteBake(0, textureGetter.apply(new class_4730(class_1723.field_21668, new class_2960(smtl.getMapKd()))), flg);
        } else {
            emitter.spriteBake(0, textureGetter.apply(MISSING), flg);
        }
        emitter.spriteColor(0, -1, -1, -1, -1);
        emitter.emit();
    }

    private void emitVertex(int index, int vertexNum, QuadEmitter emitter, class_3665 modelState, Obj fObj, ObjFace face) {
        FloatTuple vt = fObj.getVertex(face.getVertexIndex(vertexNum));
        Vector3f vertex = new Vector3f(vt.getX(), vt.getY(), vt.getZ());
        vertex.add(-0.5f, -0.5f, -0.5f);
        vertex.rotate((Quaternionfc)modelState.method_3509().method_22937());
        vertex.add(0.5f, 0.5f, 0.5f);
        FloatTuple normal = fObj.getNormal(face.getNormalIndex(vertexNum));
        FloatTuple tex = fObj.getTexCoord(face.getTexCoordIndex(vertexNum));
        emitter.pos(index, vertex.x(), vertex.y(), vertex.z()).normal(index, normal.getX(), normal.getY(), normal.getZ()).sprite(index, 0, new class_241(tex.getX(), tex.getY()));
    }
}

