package dev.felnull.specialmodelloader.api.model;

import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import dev.felnull.specialmodelloader.impl.SpecialModelLoaderClient;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ModelLoader {

    /**
     * Load the resource needed to create the model from the Resource Manager and Model Json.
     *
     * @param resourceManager Resource Manager
     * @param modelJson       Model json
     * @return Loaded Model, null if not loaded.
     */
    @Nullable LoadedResource loadResource(@NotNull class_3300 resourceManager, @NotNull JsonObject modelJson);

    /**
     * Make model from loaded resources.
     *
     * @param loadedResource Loaded resource
     * @return UnbakedModel
     */
    @NotNull class_1100 makeModel(@NotNull LoadedResource loadedResource);

    /**
     * Load model from Resource Manager and Model Json.
     *
     * @param resourceManager Resource Manager
     * @param modelJson       Model json
     * @return UnbakedModel
     */
    default @Nullable class_1100 loadModel(@NotNull class_3300 resourceManager, @NotNull JsonObject modelJson) {
        LoadedResource res = loadResource(resourceManager, modelJson);

        if (res == null) {
            return null;
        }

        return makeModel(res);
    }

    /**
     * ID of this model loader
     *
     * @return ID
     */
    @Nullable String getId();

    /**
     * Whether the model uses this model loader or not.
     *
     * @param modelLocation Model Location
     * @return true if this loader is used, false if not.
     */
    default boolean isLoaderLocation(@NotNull class_2960 modelLocation) {
        if (SpecialModelLoader.MODID.equals(modelLocation.method_12836()) || "sml".equals(modelLocation.method_12836()))
            return modelLocation.method_12832().equals("builtin/" + getId());
        return false;
    }
}
