package dev.felnull.specialmodelloader.impl;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.SpecialModelLoaderAPI;
import dev.felnull.specialmodelloader.api.model.LoadedResource;
import dev.felnull.specialmodelloader.api.model.ModelLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelLoader;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.model.NeoForgeCompat;
import dev.felnull.specialmodelloader.impl.model.obj.ObjModelLoaderImp;
import dev.felnull.specialmodelloader.impl.util.JsonUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.*;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class SpecialModelLoaderAPIImpl implements SpecialModelLoaderAPI {
    public static final SpecialModelLoaderAPIImpl INSTANCE = new SpecialModelLoaderAPIImpl();
    private final List<ModelLoader> loaders = ImmutableList.of(ObjModelLoaderImp.INSTANCE);

    @Override
    public @NotNull ObjModelLoader getObjLoader() {
        return ObjModelLoaderImp.INSTANCE;
    }

    @Override
    public @Nullable LoadedResource loadResource(@NotNull class_3300 resourceManager, @NotNull class_2960 modelLocation) {
        List<JsonObject> models = new ArrayList<>();
        JsonObject jo = readJson(resourceManager, modelLocation);

        if (NeoForgeCompat.isEnable()) {
            Pair<class_2960, ObjModelOption> forgeModel = NeoForgeCompat.getObjModelData(jo);
            if (forgeModel != null) {
                return getObjLoader().loadResource(resourceManager, forgeModel.getLeft(), forgeModel.getRight());
            }
        }

        class_2960 location = JsonUtils.getParentLocation(jo);
        Set<class_2960> parents = new HashSet<>();

        while (location != null) {
            models.add(jo);

            if (parents.contains(location)) {
                SpecialModelLoader.LOGGER.warn("Model parent specification is looping: '{}', '{}'", modelLocation, location);
                return null;
            }

            parents.add(location);

            ModelLoader loader = getLoader(location);
            if (loader != null) {
                JsonObject ret = new JsonObject();
                Collections.reverse(models);
                models.forEach(r -> r.asMap().forEach((name, rlm) -> ret.add(name, rlm.deepCopy())));
                return loader.loadResource(resourceManager, ret);
            }

            jo = readJson(resourceManager, location);
            location = JsonUtils.getParentLocation(jo);
        }

        return null;
    }

    @Override
    public @NotNull class_1100 makeModel(@NotNull LoadedResource resource) {
        return resource.getLoader().makeModel(resource);
    }

    @Override
    public @Unmodifiable @NotNull List<ModelLoader> getLoaders() {
        return loaders;
    }

    private ModelLoader getLoader(class_2960 location) {
        return getLoaders().stream()
                .filter(r -> r.isLoaderLocation(location))
                .limit(1)
                .findFirst()
                .orElse(null);
    }

    private JsonObject readJson(class_3300 resourceManager, class_2960 modelLocation) {
        class_2960 modelPath = class_2960.method_60655(modelLocation.method_12836(), "models/" + modelLocation.method_12832() + ".json");
        var res = resourceManager.method_14486(modelPath);
        if (res.isEmpty()) return null;
        JsonObject jo;
        try (var reader = res.get().method_43039()) {
            jo = class_3518.method_15255(reader);
        } catch (IOException ex) {
            throw new IllegalStateException("Failed to load json: " + modelLocation, ex);
        }
        return jo;
    }
}
