package dev.felnull.specialmodelloader.impl.handler;

import com.google.common.collect.ImmutableMap;
import dev.felnull.specialmodelloader.api.SpecialModelLoaderAPI;
import dev.felnull.specialmodelloader.api.event.SpecialModelLoaderEvents;
import dev.felnull.specialmodelloader.api.model.LoadedResource;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;

public final class SMLModelLoadingHandler {

    public static void init() {
        PreparableModelLoadingPlugin.register(SMLModelLoadingHandler::loadPrepareData, new MyModelLoadingPlugin());
    }

    private static class_1100 modifyModelOnLoad(PreparationData data, class_1100 original, ModelModifier.OnLoad.Context context) {

        class_2960 resId = context.resourceId();
        if (resId != null) {
            LoadedResource loadedResource = data.resources().get(resId);
            if (loadedResource != null) {
                return SpecialModelLoaderAPI.getInstance().makeModel(loadedResource);
            }
        }

        return original;
    }

    private static CompletableFuture<PreparationData> loadPrepareData(class_3300 resourceManager, Executor executor) {
        CompletableFuture<Predicate<class_2960>> loadScopePredicates = SpecialModelLoaderEvents.LOAD_SCOPE_ASYNC.invoker().provideAsyncLoadScopePredicate(resourceManager, executor);
        return loadScopePredicates.thenApplyAsync((lpPre) -> {
            ImmutableMap.Builder<class_2960, LoadedResource> resBuilder = ImmutableMap.builder();

            resourceManager.method_14488("models", loc -> loc.method_12832().endsWith(".json")).forEach((location, resource) -> {
                String path = location.method_12832().substring("models/".length());
                path = path.substring(0, path.length() - ".json".length());
                class_2960 modelLoc = class_2960.method_60655(location.method_12836(), path);

                if (!lpPre.test(modelLoc)) {
                    return;
                }

                LoadedResource res = SpecialModelLoaderAPI.getInstance().loadResource(resourceManager, modelLoc);
                if (res != null) {
                    resBuilder.put(modelLoc, res);
                }
            });

            return new PreparationData(resBuilder.build());
        }, executor);
    }

    private static class MyModelLoadingPlugin implements PreparableModelLoadingPlugin<PreparationData> {
        @Override
        public void onInitializeModelLoader(PreparationData data, ModelLoadingPlugin.Context pluginContext) {
            pluginContext.modifyModelOnLoad().register((model, context) -> modifyModelOnLoad(data, model, context));
        }
    }

    private record PreparationData(Map<class_2960, LoadedResource> resources) {
    }
}
