package dev.felnull.specialmodelloader.impl.model.obj;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import dev.felnull.specialmodelloader.api.model.ModelOption;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.util.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_793;
import net.minecraft.class_809;

public record ObjModelOptionImpl(ModelOption modelOption, boolean flipV, String mtlOverride,
                                 Map<String, class_2960> textures) implements ObjModelOption {

    public static ObjModelOptionImpl parse(JsonObject modelJson) {
        boolean flipV = class_3518.method_15258(modelJson, "flip_v", false);
        String mtlOverride = class_3518.method_15253(modelJson, "mtl_override", null);

        ImmutableMap.Builder<String, class_2960> textures = ImmutableMap.builder();
        if (modelJson.has("textures") && modelJson.get("textures").isJsonObject()) {
            JsonObject texturesJo = modelJson.getAsJsonObject("textures");
            texturesJo.keySet().forEach(key -> {
                class_2960 tex = JsonUtils.getResourceLocation(texturesJo, key);
                if (tex != null) {
                    textures.put(key, tex);
                }
            });
        }

        return new ObjModelOptionImpl(ModelOption.parse(modelJson), flipV, mtlOverride, textures.build());
    }

    @Override
    public boolean isFlipV() {
        return flipV;
    }

    @Nullable
    @Override
    public String getMtlOverride() {
        return mtlOverride;
    }

    @Override
    public @Unmodifiable @NotNull Map<String, class_2960> getTextures() {
        return textures;
    }

    @Override
    public boolean isUseAmbientOcclusion() {
        return modelOption.isUseAmbientOcclusion();
    }

    @Override
    public @Nullable class_793.class_4751 getGuiLight() {
        return modelOption.getGuiLight();
    }

    @Override
    public @Nullable class_2960 getParticle() {
        return modelOption.getParticle();
    }

    @Override
    public @NotNull class_809 getTransforms() {
        return modelOption.getTransforms();
    }
}
