package dev.felnull.specialmodelloader.impl.model.obj;

import de.javagl.obj.FloatTuple;
import de.javagl.obj.Mtl;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjFace;
import de.javagl.obj.ObjSplitting;
import dev.felnull.specialmodelloader.api.model.obj.ObjModelOption;
import dev.felnull.specialmodelloader.impl.SpecialModelLoader;
import dev.felnull.specialmodelloader.impl.model.SimpleMeshModel;
import dev.felnull.specialmodelloader.impl.model.SpecialBaseUnbakedModel;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.client.resources.model.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ObjUnbakedModelModel extends SpecialBaseUnbakedModel {
    private final class_2960 location;
    private final Obj obj;
    private final Map<String, Mtl> mtl;
    private final ObjModelOption option;

    public ObjUnbakedModelModel(class_2960 location, Obj obj, Map<String, Mtl> mtl, ObjModelOption option) {
        super(option);
        this.location = location;
        this.obj = obj;
        this.mtl = mtl;
        this.option = option;
    }

    @Override
    public @NotNull Collection<class_2960> method_4755() {
        return List.of();
    }

    @Override
    public void method_45785(Function<class_2960, class_1100> function) {
    }

    @Override
    public @Nullable class_1087 method_4753(class_7775 modelBaker, Function<class_4730, class_1058> textureGetter, class_3665 modelState) {
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();

        if (renderer == null) {
            SpecialModelLoader.LOGGER.warn("IndigoRenderer is used since the Renderer cannot be obtained. ({})", location);
            renderer = IndigoRenderer.INSTANCE;
        }

        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();

        Map<String, Obj> materialGroups = ObjSplitting.splitByMaterialGroups(obj);

        materialGroups.forEach((name, model) -> {
            for (int i = 0; i < model.getNumFaces(); i++) {
                emitFace(emitter, modelState, textureGetter, name, model, model.getFace(i));
            }
        });

        return new SimpleMeshModel(getModelOption().isUseAmbientOcclusion(), getGuiLight().method_24299(), textureGetter.apply(getParticleLocation()), getModelOption().getTransforms(), builder.build());
    }

    private void emitFace(QuadEmitter emitter, class_3665 modelState, Function<class_4730, class_1058> textureGetter, String materialName, Obj fObj, ObjFace face) {
        for (int i = 0; i < face.getNumVertices(); i++) {
            emitVertex(i, i, emitter, modelState, fObj, face);
        }

        if (face.getNumVertices() == 3)
            emitVertex(3, 2, emitter, modelState, fObj, face);

        var smtl = mtl.get(materialName);

        int flg = MutableQuadView.BAKE_NORMALIZED;

        if (option.isFlipV())
            flg |= MutableQuadView.BAKE_FLIP_V;

        if (modelState.method_3512())
            flg |= MutableQuadView.BAKE_LOCK_UV;

        class_2960 texLoc = null;
        String tex;
        if (smtl != null && (tex = smtl.getMapKd()) != null) {
            if (tex.startsWith("#")) {
                texLoc = option.getTextures().get(tex.substring(1));
            } else {
                texLoc = class_2960.method_60654(tex);
            }
        }

        if (texLoc != null) {
            emitter.spriteBake(textureGetter.apply(new class_4730(class_1723.field_21668, texLoc)), flg);
        } else {
            emitter.spriteBake(textureGetter.apply(MISSING), flg);
        }

        emitter.color(-1, -1, -1, -1);

        emitter.emit();
    }

    private void emitVertex(int index, int vertexNum, QuadEmitter emitter, class_3665 modelState, Obj fObj, ObjFace face) {
        var vt = fObj.getVertex(face.getVertexIndex(vertexNum));
        var vertex = new Vector3f(vt.getX(), vt.getY(), vt.getZ());

        vertex.add(-0.5f, -0.5f, -0.5f);
        vertex.rotate(modelState.method_3509().method_22937());
        vertex.add(0.5f, 0.5f, 0.5f);

        var normal = fObj.getNormal(face.getNormalIndex(vertexNum));
        var tex = fObj.getTexCoord(face.getTexCoordIndex(vertexNum));

        emitter.pos(index, vertex.x(), vertex.y(), vertex.z())
                .normal(index, normal.getX(), normal.getY(), normal.getZ())
                .uv(index, tex.getX(), tex.getY());
    }

}
