/*
 * Decompiled with CFR 0.152.
 */
package net.kunmc.lab.ikisugilogger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.kunmc.lab.ikisugilogger.AAUtils;
import net.kunmc.lab.ikisugilogger.AAs;
import net.kunmc.lab.ikisugilogger.Util;

public class IkisugiLogger {
    private static final String vowels = "aiueon";
    private static final Random random = new Random();
    private final String text;
    private ColorType colorType = ColorType.NONE;
    private int blankCount = 0;
    private boolean center;

    public IkisugiLogger(String text) {
        this.text = text;
    }

    public boolean isCenter() {
        return this.center;
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public String getText() {
        return this.text;
    }

    public void setBlankCount(int blankCount) {
        this.blankCount = blankCount;
    }

    public String create() {
        String[] texts = this.text.split("\n");
        String[][] aas = new String[texts.length][];
        ArrayList<Integer> colins = new ArrayList<Integer>();
        int[] lengths = new int[texts.length];
        int maxLine = 0;
        int maxColin = 0;
        int ct = 0;
        int act = 0;
        for (int i = 0; i < texts.length; ++i) {
            aas[i] = AAs.getDecodeAAs(texts[i]);
            int max = 0;
            if (i != 0) {
                ++maxLine;
            }
            do {
                int colinCont = 0;
                for (int j = 0; j < aas[i].length; ++j) {
                    String aa = aas[i][j];
                    String[] let = aa.split("\n");
                    max = Math.max(max, let.length);
                    String line = let.length > ct ? let[ct] : Util.stringRepeat(" ", let[let.length - 1].length());
                    colinCont += line.length();
                    colinCont += this.blankCount;
                }
                maxColin = Math.max(maxColin, colinCont);
                colins.add(colinCont);
            } while (++ct < max);
            maxLine += max;
            lengths[i] = max;
            ct = 0;
            colins.add(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxLine; ++i) {
            int txNum = 0;
            int ltcont = 0;
            for (int j = 0; j < lengths.length; ++j) {
                if (i >= ltcont && i < ltcont + lengths[j] + (j != lengths.length - 1 ? 1 : 0)) {
                    if (ltcont == i) {
                        ct = 0;
                    }
                    txNum = j;
                    break;
                }
                ltcont += lengths[j] + 1;
            }
            String[] aalt = aas[txNum];
            int colinCont = 0;
            if (this.center) {
                int ama = (maxColin - (Integer)colins.get(i)) / 2;
                sb.append(Util.stringRepeat(" ", ama));
                colinCont += ama;
            }
            for (String aa : aalt) {
                String[] let = aa.split("\n");
                String line = let.length > ct ? let[ct] : Util.stringRepeat(" ", let[let.length - 1].length());
                sb.append(this.colorType.getColorable().colorLine(line, act, colinCont, maxLine, maxColin, texts, this.center, this.blankCount));
                colinCont += line.length();
                sb.append(Util.stringRepeat(" ", this.blankCount));
                colinCont += this.blankCount;
            }
            sb.append("\n");
            ++ct;
            ++act;
        }
        if (this.colorType != ColorType.NONE) {
            sb.append("\u001b[0m");
        }
        return sb.toString();
    }

    public String createLn() {
        return "\n" + this.create();
    }

    public void setColorType(ColorType colorType) {
        this.colorType = colorType;
    }

    public ColorType getColorType() {
        return this.colorType;
    }

    private static interface Colorable {
        public String color(char var1, int var2, int var3, int var4, int var5, String[] var6, boolean var7, int var8);

        default public String colorLine(String text, int line, int column, int maxLine, int maxColumn, String[] tx, boolean center, int blankCount) {
            StringBuilder sb = new StringBuilder();
            char[] chars = text.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                sb.append(this.color(chars[i], line, column + i, maxLine, maxColumn, tx, center, blankCount));
            }
            return sb.toString();
        }
    }

    public static enum ColorType {
        NONE((n, m, l, o, p, text, center, blankCount) -> String.valueOf(n)),
        RANDOM((n, m, l, o, p, text, center, blankCount) -> {
            int[] rgb = Util.toRGB(random.nextInt(0xFFFFFF));
            return String.format("\u001b[38;2;%s;%s;%sm", rgb[0], rgb[1], rgb[2]) + n;
        }),
        RAINBOW((n, m, l, o, p, text, center, blankCount) -> {
            double line = (double)m / (double)o;
            double column = (double)l / (double)p;
            int cl = Util.convertHSBtoRGB((float)(line + column) / 2.0f, 1.0f, 1.0f);
            int[] rgb = Util.toRGB(cl);
            return String.format("\u001b[38;2;%s;%s;%sm", rgb[0], rgb[1], rgb[2]) + n;
        }),
        CHRISTMAS((n, m, l, o, p, text, center, blankCount) -> {
            int cl;
            double line = (double)m / (double)o;
            double column = (double)l / (double)p;
            double val = (line + column) / 2.0;
            int n2 = val < 0.4 ? 0x114514 : (cl = val < 0.9 ? 0x810000 : 0x364364);
            if (random.nextInt(6) == 0) {
                cl = random.nextInt(0xFFFFFF);
            }
            if (line == 0.0 && random.nextInt(3) != 0) {
                cl = 9127187;
            }
            int[] rgb = Util.toRGB(cl);
            return String.format("\u001b[38;2;%s;%s;%sm", rgb[0], rgb[1], rgb[2]) + n;
        }),
        VOWEL_ONLY(new Colorable(){

            @Override
            public String color(char c, int line, int column, int maxLine, int maxColumn, String[] text, boolean center, int blankCount) {
                int z;
                char ch;
                boolean rb;
                List ls = Arrays.stream(text).map(AAUtils::getMaxHeight).collect(Collectors.toList());
                int le = 0;
                int cl = 0;
                for (int i = 0; i < ls.size(); ++i) {
                    int l = (Integer)ls.get(i) + 1;
                    if ((cl += l) <= line) continue;
                    le = i;
                    break;
                }
                if (rb = IkisugiLogger.vowels.contains(String.valueOf(Character.toLowerCase(ch = AAUtils.getAAbyColumn(text[le], column, blankCount, z = (maxColumn - AAUtils.getAllWidth(text[le], blankCount)) / 2))))) {
                    return RAINBOW.colorable.color(c, line, column, maxLine, maxColumn, text, center, blankCount);
                }
                int[] rgb = Util.toRGB(0xA9A9A9);
                return String.format("\u001b[38;2;%s;%s;%sm", rgb[0], rgb[1], rgb[2]) + c;
            }
        });

        private final Colorable colorable;

        private ColorType(Colorable colorable) {
            this.colorable = colorable;
        }

        public Colorable getColorable() {
            return this.colorable;
        }
    }
}

