/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bettertaskbar;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.morimori0317.bettertaskbar.jni.win.WindowsLibrary;
import org.lwjgl.glfw.GLFWNativeWin32;

public class BetterTaskbarAPI {
    private static final BetterTaskbarAPI INSTANCE = new BetterTaskbarAPI();
    private static final class_310 mc = class_310.method_1551();
    public final List<Function<class_437, ProgressTotal>> progressScreens = new ArrayList<Function<class_437, ProgressTotal>>();
    private boolean support;

    private BetterTaskbarAPI() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String arc = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        this.support = os.contains("windows") && arc.contains("amd64");
    }

    public static BetterTaskbarAPI getInstance() {
        return INSTANCE;
    }

    public Path getLibraryFolderPath() {
        return Paths.get(".", new String[0]);
    }

    public boolean isSupport() {
        return this.support;
    }

    public boolean setProgress(int comp, int total) {
        long id = GLFWNativeWin32.glfwGetWin32Window((long)mc.method_22683().method_4490());
        return WindowsLibrary.setTaskbarProgress(id, class_3532.method_15340((int)comp, (int)0, (int)total), total);
    }

    public boolean setProgress(double par) {
        return this.setProgress((int)(par * 100.0), 100);
    }

    public boolean setState(State state) {
        long id = GLFWNativeWin32.glfwGetWin32Window((long)mc.method_22683().method_4490());
        WindowsLibrary.ProgressState ws = null;
        if (state == null) {
            ws = WindowsLibrary.ProgressState.TBPF_NORMAL;
        } else {
            switch (state) {
                case WAIT: {
                    ws = WindowsLibrary.ProgressState.TBPF_INDETERMINATE;
                    break;
                }
                case ERROR: {
                    ws = WindowsLibrary.ProgressState.TBPF_ERROR;
                    break;
                }
                case NO_PROGRESS: {
                    ws = WindowsLibrary.ProgressState.TBPF_NOPROGRESS;
                    break;
                }
                case NOMAL: {
                    ws = WindowsLibrary.ProgressState.TBPF_NORMAL;
                    break;
                }
                case PAUSE: {
                    ws = WindowsLibrary.ProgressState.TBPF_PAUSED;
                }
            }
        }
        return ws != null && ws.setState(id);
    }

    public void registerProgressScreenPar(Function<class_437, Double> progress) {
        this.registerProgressScreen(n -> new ProgressTotal((int)((Double)progress.apply((class_437)n) * 100.0), 100, null));
    }

    public void registerProgressScreen(Function<class_437, ProgressTotal> progress) {
        this.progressScreens.add(progress);
    }

    public static enum State {
        NO_PROGRESS,
        WAIT,
        ERROR,
        NOMAL,
        PAUSE;

    }

    public record ProgressTotal(int complete, int total, State state) {
    }
}

