/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bettertaskbar.taskbar.windows;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.util.function.BiConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.morimori0317.bettertaskbar.api.BetterTaskbarAPI;
import net.morimori0317.bettertaskbar.taskbar.ITaskbarAccess;
import net.morimori0317.bettertaskbar.taskbar.windows.ITaskbarList3;
import net.morimori0317.bettertaskbar.taskbar.windows.TaskbarList3;
import org.lwjgl.glfw.GLFWNativeWin32;

public class WindowsTaskbarAccess
implements ITaskbarAccess {
    @Override
    public void setProgress(int comp, int total) {
        this.taskbarList3((itaskbarList3, hwnd) -> {
            WinNT.HRESULT ret = itaskbarList3.SetProgressValue((WinDef.HWND)hwnd, comp, total);
            if (W32Errors.FAILED((WinNT.HRESULT)ret)) {
                throw new RuntimeException("ITaskbarList3 SetProgressValue failed");
            }
        });
    }

    @Override
    public void setState(BetterTaskbarAPI.State state) {
        this.taskbarList3((itaskbarList3, hwnd) -> {
            WinNT.HRESULT ret = itaskbarList3.SetProgressState((WinDef.HWND)hwnd, ITaskbarList3.TbpFlag.getByState(state));
            if (W32Errors.FAILED((WinNT.HRESULT)ret)) {
                throw new RuntimeException("ITaskbarList3 SetProgressState failed");
            }
        });
    }

    private void taskbarList3(BiConsumer<ITaskbarList3, WinDef.HWND> consumer) {
        class_1041 window = class_310.method_1551().method_22683();
        if (window == null) {
            return;
        }
        long id = GLFWNativeWin32.glfwGetWin32Window((long)window.method_4490());
        WinDef.HWND hwnd = new WinDef.HWND(new Pointer(id));
        Guid.CLSID clsid = new Guid.CLSID("56FDF344-FD6D-11d0-958A-006097C9A090");
        PointerByReference ref = new PointerByReference();
        WinNT.HRESULT hr = Ole32.INSTANCE.CoCreateInstance((Guid.GUID)clsid, null, 21, (Guid.GUID)TaskbarList3.IID_ITaskbarList3, ref);
        if (W32Errors.FAILED((WinNT.HRESULT)hr)) {
            throw new RuntimeException("Failed to create instance of ITaskbarList3");
        }
        TaskbarList3 tbl3 = new TaskbarList3(ref.getValue());
        WinNT.HRESULT hret = tbl3.HrInit();
        if (W32Errors.FAILED((WinNT.HRESULT)hret)) {
            throw new RuntimeException("ITaskbarList3 HrInit failed");
        }
        consumer.accept(tbl3, hwnd);
        WinNT.HRESULT rret = tbl3.Release();
        if (W32Errors.FAILED((WinNT.HRESULT)rret)) {
            throw new RuntimeException("ITaskbarList3 release failed");
        }
    }

    public static boolean check() {
        Guid.CLSID clsid = new Guid.CLSID("56FDF344-FD6D-11d0-958A-006097C9A090");
        PointerByReference ref = new PointerByReference();
        WinNT.HRESULT hr = Ole32.INSTANCE.CoCreateInstance((Guid.GUID)clsid, null, 21, (Guid.GUID)TaskbarList3.IID_ITaskbarList3, ref);
        if (W32Errors.FAILED((WinNT.HRESULT)hr)) {
            return false;
        }
        TaskbarList3 tbl3 = new TaskbarList3(ref.getValue());
        WinNT.HRESULT hret = tbl3.HrInit();
        if (W32Errors.FAILED((WinNT.HRESULT)hret)) {
            return false;
        }
        WinNT.HRESULT rret = tbl3.Release();
        return !W32Errors.FAILED((WinNT.HRESULT)rret);
    }
}

