/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bettertaskbar;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.morimori0317.bettertaskbar.jni.win.WindowsLibrary;
import org.lwjgl.glfw.GLFWNativeWin32;

public class BetterTaskbarAPI {
    private static final BetterTaskbarAPI INSTANCE = new BetterTaskbarAPI();
    private static final Minecraft mc = Minecraft.m_91087_();
    protected final List<Function<Screen, ProgressTotal>> progressScreens = new ArrayList<Function<Screen, ProgressTotal>>();
    private boolean support;

    private BetterTaskbarAPI() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String arc = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        this.support = os.contains("windows") && arc.contains("amd64");
    }

    public static BetterTaskbarAPI getInstance() {
        return INSTANCE;
    }

    public Path getLibraryFolderPath() {
        return Paths.get(".", new String[0]);
    }

    public boolean isSupport() {
        return this.support;
    }

    public boolean setProgress(int comp, int total) {
        long id = GLFWNativeWin32.glfwGetWin32Window((long)mc.m_91268_().m_85439_());
        return WindowsLibrary.setTaskbarProgress(id, Mth.m_14045_((int)comp, (int)0, (int)total), total);
    }

    public boolean setProgress(double par) {
        return this.setProgress((int)(par * 100.0), 100);
    }

    public boolean setState(State state) {
        long id = GLFWNativeWin32.glfwGetWin32Window((long)mc.m_91268_().m_85439_());
        WindowsLibrary.ProgressState ws = null;
        if (state == null) {
            ws = WindowsLibrary.ProgressState.TBPF_NORMAL;
        } else {
            switch (state) {
                case WAIT: {
                    ws = WindowsLibrary.ProgressState.TBPF_INDETERMINATE;
                    break;
                }
                case ERROR: {
                    ws = WindowsLibrary.ProgressState.TBPF_ERROR;
                    break;
                }
                case NO_PROGRESS: {
                    ws = WindowsLibrary.ProgressState.TBPF_NOPROGRESS;
                    break;
                }
                case NOMAL: {
                    ws = WindowsLibrary.ProgressState.TBPF_NORMAL;
                    break;
                }
                case PAUSE: {
                    ws = WindowsLibrary.ProgressState.TBPF_PAUSED;
                }
            }
        }
        return ws != null && ws.setState(id);
    }

    public void registerProgressScreenPar(Function<Screen, Double> progress) {
        this.registerProgressScreen(n -> new ProgressTotal((int)((Double)progress.apply((Screen)n) * 100.0), 100, null));
    }

    public void registerProgressScreen(Function<Screen, ProgressTotal> progress) {
        this.progressScreens.add(progress);
    }

    public static enum State {
        NO_PROGRESS,
        WAIT,
        ERROR,
        NOMAL,
        PAUSE;

    }

    public record ProgressTotal(int complete, int total, State state) {
    }
}

