/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bettertaskbar.jni.win;

import net.morimori0317.bettertaskbar.jni.JNILibraryLoader;
import net.morimori0317.bettertaskbar.jni.win.WindowsNative;

public class WindowsLibrary {
    private static boolean check() {
        if (!JNILibraryLoader.isInited()) {
            JNILibraryLoader.init();
        }
        return JNILibraryLoader.isLoaded();
    }

    public static boolean setTaskbarProgress(long id, int completed, int total) {
        if (!WindowsLibrary.check()) {
            return false;
        }
        return WindowsNative.setTaskbarProgressValue(id, completed, total);
    }

    public static boolean setTaskbarProgressState(long id, ProgressState state) {
        if (!WindowsLibrary.check()) {
            return false;
        }
        return WindowsNative.setTaskbarProgressState(id, state.getNum());
    }

    public static enum ProgressState {
        TBPF_NOPROGRESS(0),
        TBPF_INDETERMINATE(1),
        TBPF_NORMAL(2),
        TBPF_ERROR(4),
        TBPF_PAUSED(8);

        private final int num;

        private ProgressState(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }

        public boolean setState(long id) {
            return WindowsLibrary.setTaskbarProgressState(id, this);
        }
    }
}

