package net.morimori0317.bettertaskbar;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.*;
import net.morimori0317.bettertaskbar.api.BetterTaskbarAPI;
import var;

public class TaskbarHandler {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static Screen lastScreen;

    public static void tick() {
        if (mc.f_91080_ != null) screenTick();
        if (lastScreen != mc.f_91080_) {
            if (lastScreen != null) screenChange(lastScreen);
            lastScreen = mc.f_91080_;
        }
    }

    private static void screenTick() {
        var api = BetterTaskbarAPI.getInstance();
        if (mc.f_91080_ instanceof LevelLoadingScreen loadingScreen) {
            api.setProgress(Math.max(loadingScreen.f_96138_.m_9674_(), 1), 100);
        } else if (mc.f_91080_ instanceof ProgressScreen || mc.f_91080_ instanceof ConnectScreen || mc.f_91080_ instanceof ReceivingLevelScreen) {
            api.setState(BetterTaskbarAPI.State.WAIT);
        } else if (mc.f_91080_ instanceof ConfirmScreen) {
            api.setState(BetterTaskbarAPI.State.PAUSE);
        } else if (mc.f_91080_ instanceof DisconnectedScreen) {
            api.setState(BetterTaskbarAPI.State.ERROR);
        }
    }

    private static void screenChange(Screen lastScreen) {
        var api = BetterTaskbarAPI.getInstance();
        if (api.isUpdated() && (lastScreen instanceof DisconnectedScreen || lastScreen instanceof LevelLoadingScreen || lastScreen instanceof ProgressScreen || lastScreen instanceof ConnectScreen || lastScreen instanceof ConfirmScreen || lastScreen instanceof ReceivingLevelScreen)) {
            api.setState(BetterTaskbarAPI.State.NO_PROGRESS);
            api.setProgress(0);
            api.setUpdated(false);
        }
    }
}
