/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bettertaskbar.taskbar.windows;

import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import net.morimori0317.bettertaskbar.api.BetterTaskbarAPI;

public interface ITaskbarList3 {
    public static final Guid.IID IID_ITaskbarList3 = new Guid.IID("ea1afb91-9e28-4b86-90e9-9e9f8a5eefaf");

    public WinNT.HRESULT HrInit();

    public WinNT.HRESULT SetProgressValue(WinDef.HWND var1, long var2, long var4);

    public WinNT.HRESULT SetProgressState(WinDef.HWND var1, TbpFlag var2);

    public WinNT.HRESULT Release();

    public static enum TbpFlag {
        TBPF_NOPROGRESS(0),
        TBPF_INDETERMINATE(1),
        TBPF_NORMAL(2),
        TBPF_ERROR(4),
        TBPF_PAUSED(8);

        private final int num;

        private TbpFlag(int num) {
            this.num = num;
        }

        public int getNum() {
            return this.num;
        }

        public static TbpFlag getByState(BetterTaskbarAPI.State state) {
            return switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case BetterTaskbarAPI.State.WAIT -> TBPF_INDETERMINATE;
                case BetterTaskbarAPI.State.ERROR -> TBPF_ERROR;
                case BetterTaskbarAPI.State.NO_PROGRESS -> TBPF_NOPROGRESS;
                case BetterTaskbarAPI.State.NORMAL -> TBPF_NORMAL;
                case BetterTaskbarAPI.State.PAUSE -> TBPF_PAUSED;
            };
        }
    }
}

