/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.bettertaskbar.api;

import net.morimori0317.bettertaskbar.BetterTaskbar;
import net.morimori0317.bettertaskbar.taskbar.ITaskbarAccess;

public class BetterTaskbarAPI {
    private static final BetterTaskbarAPI INSTANCE = new BetterTaskbarAPI();
    private boolean updated;
    private float lastProgress;
    private State lastState;
    private int lastComp;
    private int lastTotal;

    public static BetterTaskbarAPI getInstance() {
        return INSTANCE;
    }

    public void setProgress(int comp, int total) {
        this.setState(State.NORMAL);
        boolean flg = false;
        if (this.lastComp != comp) {
            this.lastComp = comp;
            flg = true;
        }
        if (this.lastTotal != total) {
            this.lastTotal = total;
            flg = true;
        }
        if (flg) {
            ITaskbarAccess ac = BetterTaskbar.getTaskbarAccess();
            ac.setProgress(comp, total);
            this.updated = true;
        }
    }

    public void setProgress(float value) {
        this.setState(State.NORMAL);
        if (this.lastProgress != value) {
            this.lastProgress = value;
            ITaskbarAccess ac = BetterTaskbar.getTaskbarAccess();
            ac.setProgress(value);
            this.updated = true;
        }
    }

    public void setState(State state) {
        if (this.lastState != state) {
            this.lastState = state;
            ITaskbarAccess ac = BetterTaskbar.getTaskbarAccess();
            ac.setState(state);
            this.updated = true;
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public static enum State {
        NO_PROGRESS,
        WAIT,
        ERROR,
        NORMAL,
        PAUSE;

    }
}

