/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.mus;

import com.mojang.blaze3d.vertex.PoseStack;
import net.morimori0317.mus.MemoryUsageOverlay;
import net.morimori0317.mus.MemoryUsageScreen;

public class MemoryUsageManager {
    private static final MemoryUsageManager INSTANCE = new MemoryUsageManager();
    public final MemoryUsageOverlay overlay = new MemoryUsageOverlay();
    public boolean enableShowMemoryUsage;

    public static MemoryUsageManager getInstance() {
        return INSTANCE;
    }

    public void toggleShowMemoryUsage() {
        this.setShowMemoryUsageEnabled(!this.enableShowMemoryUsage);
    }

    public void setShowMemoryUsageEnabled(boolean enabled) {
        if (!enabled && this.enableShowMemoryUsage) {
            this.overlay.reset();
        }
        this.enableShowMemoryUsage = enabled;
    }

    public void onTick() {
        if (MemoryUsageScreen.isConfigEnableToggleMode()) {
            while (MemoryUsageScreen.showMemoryBarKey.m_90859_()) {
                this.toggleShowMemoryUsage();
            }
        } else {
            boolean press = MemoryUsageScreen.showMemoryBarKey.m_90857_();
            this.setShowMemoryUsageEnabled(press);
        }
    }

    public void onGUIKeyPress(int code) {
        if (code == MemoryUsageScreen.showMemoryBarKey.getKey().m_84873_()) {
            this.toggleShowMemoryUsage();
        }
    }

    public void onRender(PoseStack poseStack) {
        if (this.enableShowMemoryUsage) {
            this.overlay.render(poseStack, 1.0f, true, true);
        }
    }

    public void onWorldLoadingReset() {
        if (MemoryUsageScreen.isConfigEnableWorldLoadingScreen()) {
            this.overlay.reset();
        }
    }

    public void onWorldLoadingRender(PoseStack poseStack) {
        if (MemoryUsageScreen.isConfigEnableWorldLoadingScreen() && !this.enableShowMemoryUsage) {
            this.overlay.render(poseStack, 1.0f, true, true);
        }
    }

    public void onLoadingRender(PoseStack poseStack, float alpha, boolean useFont, boolean bloackGrond) {
        if (MemoryUsageScreen.isConfigEnableInitLoadingScreen() && !this.enableShowMemoryUsage) {
            this.overlay.render(poseStack, alpha, useFont, bloackGrond);
        }
    }
}

