/*
 * Decompiled with CFR 0.152.
 */
package net.morimori0317.mus;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class MemoryUsageOverlay
extends GuiComponent {
    private static final ResourceLocation FONT_LOCATION = new ResourceLocation("textures/font/ascii.png");
    private static final Minecraft mc = Minecraft.m_91087_();
    private float maxBar;

    public void render(PoseStack poseStack, float alpha, boolean useFont, boolean bloackGrond) {
        poseStack.m_85836_();
        int colw = FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)255, (int)255, (int)255);
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long usage = total - free;
        float currentUsage = (float)usage / (float)max;
        float currentAllocated = (float)total / (float)max;
        float wringWar = 0.33333334f;
        float cr = (Mth.m_14036_((float)currentUsage, (float)wringWar, (float)(wringWar * 2.0f)) - wringWar) / wringWar;
        float cg = 1.0f - (Mth.m_14036_((float)currentUsage, (float)(wringWar * 2.0f), (float)1.0f) - wringWar * 2.0f) / wringWar;
        int colmem = FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)Math.round(cr * 255.0f), (int)Math.round(cg * 255.0f), (int)0);
        int sw = mc.m_91268_().m_85445_();
        int sh = mc.m_91268_().m_85446_();
        int w = 246;
        int h = 11;
        int sx = sw / 2 - w / 2;
        int sy = (int)((double)sh * 0.08);
        if (currentUsage > this.maxBar) {
            this.maxBar = currentUsage;
        }
        this.renderCenterString("Memory Used / Total", poseStack, sw / 2, sy - 10, 1.0f, 1.0f, 1.0f, alpha, useFont);
        if (bloackGrond) {
            this.cfill(poseStack, sx, sy, w, h, FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)0, (int)0, (int)0));
        }
        this.cfill(poseStack, sx, sy, 1, h, colw);
        this.cfill(poseStack, sx + w - 1, sy, 1, h, colw);
        this.cfill(poseStack, sx + 1, sy, w - 2, 1, colw);
        this.cfill(poseStack, sx + 1, sy + h - 1, w - 2, 1, colw);
        this.cfill(poseStack, sx + 2, sy + 2, (int)((float)(w - 4) * currentUsage), h - 4, colmem);
        this.cfill(poseStack, sx + 2 + (int)((float)(w - 4) * this.maxBar), sy + 1, 1, h - 2, FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)0, (int)0, (int)255));
        this.cfill(poseStack, sx + 2 + (int)((float)(w - 4) * currentAllocated), sy + 1, 1, h - 2, FastColor.ARGB32.m_13660_((int)Math.round(alpha * 255.0f), (int)255, (int)0, (int)0));
        this.renderCenterString(String.format("%03d/%03dMB", this.bytesToMegabytes(usage), this.bytesToMegabytes(max)), poseStack, sw / 2, sy + 2, 1.0f, 1.0f, 1.0f, alpha, useFont);
        poseStack.m_85849_();
    }

    private void cfill(PoseStack poseStack, int x, int y, int w, int h, int col) {
        MemoryUsageOverlay.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)col);
    }

    private void renderCenterString(String str, PoseStack poseStack, int x, int y, float r, float g, float b, float a, boolean useFont) {
        int size;
        if (!useFont) {
            str = str.toUpperCase();
        }
        int n = size = useFont ? MemoryUsageOverlay.mc.f_91062_.m_92895_(str) : str.length() * 6;
        if (useFont) {
            int col = FastColor.ARGB32.m_13660_((int)Math.round(a * 255.0f), (int)Math.round(r * 255.0f), (int)Math.round(g * 255.0f), (int)Math.round(b * 255.0f));
            MemoryUsageOverlay.mc.f_91062_.m_92883_(poseStack, str, (float)x - (float)size / 2.0f, (float)y, col);
        } else {
            this.renderNoFontString(str, poseStack, x - size / 2, y, a, r, g, b);
        }
    }

    private void renderNoFontString(String str, PoseStack poseStack, int x, int y, float alpha, float r, float g, float b) {
        for (int a = 0; a < str.length(); ++a) {
            char ch = str.charAt(a);
            if (ch > '\u00ff') continue;
            int tsx = (ch & 0xF) * 8;
            int tsy = (ch >> 4 & 0xF) * 8;
            this.drawTexture(FONT_LOCATION, poseStack, x + a * 6, y, tsx, tsy, 6, 7, 128, 128, r, g, b, alpha);
        }
    }

    private long bytesToMegabytes(long l) {
        return l / 1024L / 1024L;
    }

    private void drawTexture(ResourceLocation location, PoseStack psstack, int x, int y, int textureStartX, int textureStartY, int textureFinishWidth, int textureFinishHeight, int textureSizeX, int textureSizeY, float r, float g, float b, float a) {
        psstack.m_85836_();
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        RenderSystem.m_69478_();
        RenderSystem.m_69403_((int)32774);
        RenderSystem.m_69405_((int)770, (int)1);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        GuiComponent.m_93133_((PoseStack)psstack, (int)x, (int)y, (float)textureStartX, (float)textureStartY, (int)textureFinishWidth, (int)textureFinishHeight, (int)textureSizeX, (int)textureSizeY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        psstack.m_85849_();
    }

    public void reset() {
        this.maxBar = 0.0f;
    }
}

