/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportYoutubePlayListBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.PlayListBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.SavedPlayListBaseMMMonitor;
import dev.felnull.imp.client.music.loadertypes.IMPMusicLoaderTypes;
import dev.felnull.imp.client.music.loadertypes.MusicLoadResult;
import dev.felnull.imp.client.music.loadertypes.YoutubeMusicLoaderType;
import dev.felnull.imp.client.util.LavaPlayerUtil;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.apache.commons.lang3.tuple.Pair;

public class CreatePlayListMMMonitor
extends SavedPlayListBaseMMMonitor {
    protected static final class_2561 IMPORT_TEXT = new class_2588("imp.button.import");
    protected static final class_2561 IMPORTING_TEXT = new class_2588("imp.text.importing");
    protected static final class_2561 IMPORT_FAILURE_TEXT = new class_2588("imp.text.importFailure");
    private ImportMusicLoader importMusicLoader;
    private boolean failureImportPlayList;

    public CreatePlayListMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        class_2561 ipTx = null;
        if (this.isImporting()) {
            ipTx = IMPORTING_TEXT;
        } else if (this.failureImportPlayList) {
            ipTx = IMPORT_FAILURE_TEXT;
        } else if (this.getImportMusicsCount() > 0) {
            ipTx = new class_2588("imp.text.importMusicCount", new Object[]{this.getImportMusicsCount()});
        }
        if (ipTx != null) {
            this.drawSmartText(poseStack, ipTx, this.getStartX() + this.width - 95 + 7, this.getStartY() + 184);
        }
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 95 - 87, this.getStartY() + 180, 87, 15, IMPORT_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.IMPORT_PLAY_LIST_SELECT)));
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 95 - 87, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, IMPORT_TEXT, true);
        if (this.getImportMusicsCount(blockEntity) > 0) {
            this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)new class_2588("imp.text.importMusicCount", new Object[]{this.getImportMusicsCount(blockEntity)}), this.width - 95 + 7, 184.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        }
    }

    @Override
    public boolean done(ImageInfo imageInfo, String name) {
        if (this.isImporting()) {
            return false;
        }
        PlayListBaseMMMonitor.PublishingType pubType = this.getPublishingType();
        PlayListBaseMMMonitor.InitialAuthorityType initAuthType = this.getInitialAuthorityType();
        List<UUID> invitePlayers = this.getInvitePlayers();
        String ipl = this.getImportPlayList();
        if (this.getImportMusicsCount() > 0 && !ipl.isEmpty()) {
            this.startImportMusicLoader(ipl);
            return false;
        }
        this.sendAddPacket(imageInfo, name, pubType, initAuthType, invitePlayers, new ArrayList<Music>());
        return true;
    }

    private void sendAddPacket(ImageInfo imageInfo, String name, PlayListBaseMMMonitor.PublishingType pubType, PlayListBaseMMMonitor.InitialAuthorityType initAuthType, List<UUID> invitePlayers, List<Music> importMusics) {
        NetworkManager.sendToServer((class_2960)IMPPackets.MUSIC_PLAYLIST_ADD, (class_2540)new IMPPackets.MusicPlayListMessage(name, imageInfo, pubType == PlayListBaseMMMonitor.PublishingType.PUBLIC, initAuthType == PlayListBaseMMMonitor.InitialAuthorityType.MEMBER, invitePlayers, BlockEntityExistence.getByBlockEntity((class_2586)this.getScreen().getBlockEntity()), importMusics).toFBB());
    }

    @Override
    protected ImageNameBaseMMMonitor.DoneType getDoneType() {
        return ImageNameBaseMMMonitor.DoneType.CREATE;
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.ADD_PLAY_LIST;
    }

    private int getImportMusicsCount() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getImportMusicsCount(musicManagerBlockEntity);
        }
        return 0;
    }

    private void startImportMusicLoader(String id) {
        this.stopImportMusicLoader();
        this.failureImportPlayList = false;
        this.importMusicLoader = new ImportMusicLoader(id);
        this.importMusicLoader.start();
    }

    private void stopImportMusicLoader() {
        if (this.importMusicLoader != null) {
            this.importMusicLoader.interrupt();
            this.importMusicLoader = null;
        }
    }

    private String getImportPlayList() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getImportPlayList(musicManagerBlockEntity);
        }
        return "";
    }

    private String getImportPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMyImportIdentifier();
    }

    private int getImportMusicsCount(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMyImportPlayListMusicCount();
    }

    private boolean isImporting() {
        return this.importMusicLoader != null && this.importMusicLoader.isAlive();
    }

    private class ImportMusicLoader
    extends Thread {
        private final String id;

        private ImportMusicLoader(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            try {
                ArrayList<Music> musics = new ArrayList<Music>();
                Pair<AudioPlaylist, List<AudioTrack>> pl = LavaPlayerUtil.loadTracks(this.getYoutubeLoaderType().getAudioPlayerManager(), this.id);
                if (pl.getLeft() == null) {
                    throw new IllegalStateException("Not PlayList");
                }
                for (AudioTrack track : (List)pl.getRight()) {
                    if (track.getInfo().isStream) continue;
                    MusicLoadResult ret = this.getYoutubeLoaderType().createResult(track);
                    ImportYoutubePlayListBaseMMMonitor.YoutubePlayListEntry en = new ImportYoutubePlayListBaseMMMonitor.YoutubePlayListEntry(ret.name(), ret.author(), ret.source(), ret.imageInfo());
                    Music music = new Music(UUID.randomUUID(), en.name(), en.artist(), en.source(), en.imageInfo(), IIMPSmartRender.mc.field_1724.method_7334().getId(), System.currentTimeMillis());
                    musics.add(music);
                }
                IIMPSmartRender.mc.method_20493(() -> {
                    ImageInfo imageInfo = CreatePlayListMMMonitor.this.getImage();
                    String name = CreatePlayListMMMonitor.this.getName();
                    PlayListBaseMMMonitor.PublishingType pubType = CreatePlayListMMMonitor.this.getPublishingType();
                    PlayListBaseMMMonitor.InitialAuthorityType initAuthType = CreatePlayListMMMonitor.this.getInitialAuthorityType();
                    List<UUID> invitePlayers = CreatePlayListMMMonitor.this.getInvitePlayers();
                    CreatePlayListMMMonitor.this.sendAddPacket(imageInfo, name, pubType, initAuthType, invitePlayers, musics);
                    CreatePlayListMMMonitor.this.insMonitor(MusicManagerBlockEntity.MonitorType.PLAY_LIST);
                });
            }
            catch (Exception ex) {
                CreatePlayListMMMonitor.this.failureImportPlayList = true;
            }
        }

        private YoutubeMusicLoaderType getYoutubeLoaderType() {
            return (YoutubeMusicLoaderType)IMPMusicLoaderTypes.getLoaderType("youtube");
        }
    }
}

