/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.util.FileChooserUtil;
import dev.felnull.imp.libs.com.mpatric.mp3agic.Mp3File;
import dev.felnull.imp.libs.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.otyacraftengine.util.OEURLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class UploadMusicMMMonitor
extends MusicManagerMonitor {
    private static final Gson GSON = new Gson();
    private static final int relayServerVersion = 1;
    private static final class_2561 BACK_TEXT = new class_2588("gui.back");
    private static final class_2561 RELAY_SERVER_TEXT = new class_2588("imp.text.relayServer");
    private static final class_2561 CONNECTING_CHECKING = new class_2588("imp.text.relayServer.connectingChecking");
    private static final class_2561 DROP_INFO_TEXT = new class_2588("imp.text.uploadDropInfo");
    private static final class_2561 OPEN_FILE_TEXT = new class_2588("imp.button.openFile");
    private static final class_2561 UPLOADING_TEXT = new class_2588("imp.text.relayServer.uploading");
    private static final class_2561 WARNING_TEXT = new class_2588("imp.text.relayServer.warning");
    private static final class_2561 RESPONSIBILITY_TEXT = new class_2588("imp.text.relayServer.responsibility");
    private static final class_2561 HOW_TEXT = new class_2588("imp.text.relayServer.how");
    private SmartButton openFileButton;
    private class_2561 RELAY_SERVER_NAME_TEXT;
    private class_2561 UPLOAD_INFO_TEXT;
    private class_2561 UPLOAD_ERROR_TEXT;
    private boolean connected;
    private class_2561 SERVER_STATUS_TEXT;
    private ServerConnectingCheckThread connectingCheckThread;
    private UploadThread uploadThread;
    private long maxFileSize;
    private String uploadUrl;
    private boolean error;

    public UploadMusicMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.startConnectingCheck();
        this.addRenderWidget(new SmartButton(this.getStartX() + (this.width - 270) / 2, this.getStartY() + 180, 270, 15, BACK_TEXT, n -> this.insMonitor(this.getParentType())));
        this.openFileButton = this.addRenderWidget(new SmartButton(this.getStartX() + (this.width - 270) / 2, this.getStartY() + 103, 270, 15, OPEN_FILE_TEXT, n -> this.uploadFile(FileChooserUtil.openMusicFileChooser(false))));
        this.openFileButton.setIcon(WIDGETS_TEXTURE, 73, 19, 11, 11);
        this.openFileButton.field_22764 = this.canUpload();
    }

    @Override
    public void depose() {
        super.depose();
        this.stopConnectingCheckThread();
        this.stopUploadThread();
        this.RELAY_SERVER_NAME_TEXT = null;
        this.UPLOAD_INFO_TEXT = null;
        this.UPLOAD_ERROR_TEXT = null;
        this.connected = false;
        this.error = false;
        this.SERVER_STATUS_TEXT = null;
        this.uploadUrl = null;
    }

    @Override
    public void onFilesDrop(List<Path> list) {
        File[] files = new File[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            files[i] = list.get(i).toFile();
        }
        this.uploadFile(files);
    }

    private void uploadFile(File[] files) {
        if (!this.canUpload() || files == null || files.length == 0) {
            return;
        }
        if (files.length != 1) {
            this.UPLOAD_ERROR_TEXT = new class_2588("imp.text.fileUpload.tooManyFiles");
            return;
        }
        this.UPLOAD_ERROR_TEXT = null;
        File file = files[0];
        if (file.isDirectory()) {
            this.UPLOAD_ERROR_TEXT = new class_2588("imp.text.fileUpload.directory");
            return;
        }
        if (file.exists()) {
            if (file.length() > this.maxFileSize) {
                this.UPLOAD_ERROR_TEXT = new class_2588("imp.text.fileUpload.sizeOver");
                return;
            }
            this.startUploadThread(file);
        } else {
            this.UPLOAD_ERROR_TEXT = new class_2588("imp.text.fileUpload.fileNotFound");
        }
    }

    private boolean isConnectChecking() {
        return this.connectingCheckThread != null && this.connectingCheckThread.isAlive();
    }

    private boolean canUpload() {
        return !this.isConnectChecking() && this.connected && this.uploadUrl != null;
    }

    private boolean isUploading() {
        return this.uploadThread != null && this.uploadThread.isAlive();
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        int py;
        super.render(poseStack, f, mouseX, mouseY);
        float st = (float)this.getStartX() + ((float)this.width - 270.0f) / 2.0f;
        this.drawSmartText(poseStack, RELAY_SERVER_TEXT, st, this.getStartY() + 13);
        if (this.RELAY_SERVER_NAME_TEXT != null) {
            this.drawSmartText(poseStack, this.RELAY_SERVER_NAME_TEXT, st, this.getStartY() + 23, -16744448);
        }
        class_2561 tx = this.SERVER_STATUS_TEXT;
        int n = py = this.error ? 0 : 10;
        if (this.isConnectChecking()) {
            tx = CONNECTING_CHECKING;
            py = 0;
        }
        if (tx != null) {
            this.drawSmartFixedWidthText(poseStack, tx, st, this.getStartY() + 23 + py, 270.0f);
        }
        if (this.canUpload()) {
            if (!this.isUploading()) {
                this.drawSmartText(poseStack, DROP_INFO_TEXT, st, this.getStartY() + 120);
            }
            if (this.UPLOAD_INFO_TEXT != null) {
                this.drawSmartText(poseStack, this.UPLOAD_INFO_TEXT, st, this.getStartY() + 43);
            }
            if (this.UPLOAD_ERROR_TEXT != null && !this.isUploading()) {
                this.drawSmartText(poseStack, this.UPLOAD_ERROR_TEXT, st, this.getStartY() + 83, -65536);
            }
            this.drawSmartFixedWidthText(poseStack, HOW_TEXT, st, this.getStartY() + 53, 270.0f, -16776961);
            this.drawSmartFixedWidthText(poseStack, WARNING_TEXT, st, this.getStartY() + 63, 270.0f, -65536);
            this.drawSmartFixedWidthText(poseStack, RESPONSIBILITY_TEXT, st, this.getStartY() + 73, 270.0f, -65536);
            if (this.isUploading()) {
                this.drawSmartText(poseStack, UPLOADING_TEXT, st, this.getStartY() + 83);
            }
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartButtonSprite(poseStack, multiBufferSource, ((float)this.width - 270.0f) / 2.0f, 180.0f, 0.002f, 270.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, BACK_TEXT, true, false);
        float st = ((float)this.width - 270.0f) / 2.0f;
        this.renderSmartTextSprite(poseStack, multiBufferSource, RELAY_SERVER_TEXT, st, 13.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.ADD_MUSIC;
    }

    private void startConnectingCheck() {
        this.stopConnectingCheckThread();
        this.connected = false;
        this.error = false;
        this.connectingCheckThread = new ServerConnectingCheckThread();
        this.connectingCheckThread.start();
    }

    private void stopConnectingCheckThread() {
        if (this.connectingCheckThread != null) {
            this.connectingCheckThread.interrupt();
            this.connectingCheckThread = null;
        }
    }

    private void startUploadThread(File file) {
        this.stopUploadThread();
        this.uploadThread = new UploadThread(file);
        this.uploadThread.start();
    }

    private void stopUploadThread() {
        if (this.uploadThread != null) {
            this.uploadThread.interrupt();
            this.uploadThread = null;
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.openFileButton.field_22764 = this.canUpload() && !this.isUploading();
    }

    private void setMusicSourceName(String name) {
        this.getScreen().insMusicSourceName(name);
    }

    private void setCreateName(String name) {
        this.getScreen().insCreateName(name);
    }

    private String uploadToFile(byte[] data) throws IOException, InterruptedException {
        if (this.uploadUrl == null) {
            return null;
        }
        String url = this.uploadUrl + "music-upload";
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).header("mc-uuid", IIMPSmartRender.mc.field_1724.method_7334().getId().toString()).POST(HttpRequest.BodyPublishers.ofByteArray(data)).build();
        HttpResponse<String> res = client.send(req, HttpResponse.BodyHandlers.ofString());
        JsonObject jo = (JsonObject)GSON.fromJson(res.body(), JsonObject.class);
        return jo.get("url").getAsString();
    }

    private byte[] getMusicImage(File file) {
        try {
            Mp3File mp3 = new Mp3File(file);
            return mp3.getId3v2Tag().getAlbumImage();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class ServerConnectingCheckThread
    extends Thread {
        private ServerConnectingCheckThread() {
        }

        @Override
        public void run() {
            try {
                String url = IamMusicPlayer.CONFIG.relayServerURL;
                String status = null;
                JsonObject lastJo = null;
                long eqTime = 0L;
                while (status == null) {
                    Pair<Long, JsonObject> jop = this.getResponse(url);
                    eqTime = (Long)jop.getLeft();
                    JsonObject jo = (JsonObject)jop.getRight();
                    if (jo == null || !jo.has("Status")) {
                        status = "Offline";
                        lastJo = jo;
                        continue;
                    }
                    String st = jo.get("Status").getAsString();
                    if ("Transfer".equalsIgnoreCase(st)) {
                        String v = String.valueOf(1);
                        if (jo.has(v)) {
                            JsonObject vjo = jo.get(v).getAsJsonObject();
                            if (vjo.has("url")) {
                                url = vjo.get("url").getAsString();
                                continue;
                            }
                            status = "Transfer Failure";
                            lastJo = jo;
                            continue;
                        }
                        status = "Transfer Failure";
                        lastJo = jo;
                        continue;
                    }
                    status = st;
                    lastJo = jo;
                }
                if ("Ok".equalsIgnoreCase(status)) {
                    String name = "No Name";
                    if (lastJo.has("Name")) {
                        name = lastJo.get("Name").getAsString();
                    }
                    UploadMusicMMMonitor.this.RELAY_SERVER_NAME_TEXT = new class_2585(name);
                    JsonObject time = null;
                    if (lastJo.has("Time")) {
                        time = lastJo.getAsJsonObject("Time");
                    }
                    long rt = 0L;
                    if (time != null && time.has("ResponseSpeed")) {
                        rt = time.get("ResponseSpeed").getAsLong();
                    }
                    if (time != null && time.has("ResponseSpeed")) {
                        UploadMusicMMMonitor.this.SERVER_STATUS_TEXT = new class_2588("imp.text.relayServer.response", new Object[]{eqTime, rt});
                    }
                    UploadMusicMMMonitor.this.maxFileSize = lastJo.get("MaxFileSize").getAsLong();
                    UploadMusicMMMonitor.this.UPLOAD_INFO_TEXT = new class_2588("imp.text.relayServer.uploadInfo", new Object[]{FNStringUtil.getByteDisplay(UploadMusicMMMonitor.this.maxFileSize, 1024L)});
                    String v = null;
                    if (lastJo.has("Version")) {
                        v = lastJo.get("Version").getAsString();
                    }
                    if (v != null) {
                        UploadMusicMMMonitor.this.RELAY_SERVER_NAME_TEXT = ((class_2585)UploadMusicMMMonitor.this.RELAY_SERVER_NAME_TEXT).method_27693(" V" + v);
                    }
                    UploadMusicMMMonitor.this.uploadUrl = url;
                    UploadMusicMMMonitor.this.connected = true;
                } else {
                    UploadMusicMMMonitor.this.SERVER_STATUS_TEXT = new class_2588("imp.text.relayServer.error", new Object[]{status}).method_27692(class_124.field_1061);
                    UploadMusicMMMonitor.this.error = true;
                }
            }
            catch (Exception ex) {
                UploadMusicMMMonitor.this.SERVER_STATUS_TEXT = new class_2588("imp.text.relayServer.error", new Object[]{ex.getMessage()}).method_27692(class_124.field_1061);
                UploadMusicMMMonitor.this.error = true;
            }
        }

        @NotNull
        private Pair<Long, JsonObject> getResponse(String url) {
            long st = System.currentTimeMillis();
            JsonObject jo = null;
            try {
                jo = OEURLUtil.getJson((URL)new URL(url));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Pair.of((Object)(System.currentTimeMillis() - st), (Object)jo);
        }
    }

    private class UploadThread
    extends Thread {
        private final File file;

        private UploadThread(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                String url = UploadMusicMMMonitor.this.uploadToFile(Files.readAllBytes(this.file.toPath()));
                if (url == null || url.isEmpty()) {
                    UploadMusicMMMonitor.this.UPLOAD_ERROR_TEXT = new class_2588("imp.text.fileUpload.noURL");
                } else {
                    UploadMusicMMMonitor.this.UPLOAD_ERROR_TEXT = null;
                    byte[] img = UploadMusicMMMonitor.this.getMusicImage(this.file);
                    IIMPSmartRender.mc.method_20493(() -> {
                        UploadMusicMMMonitor.this.setMusicSourceName(url);
                        UploadMusicMMMonitor.this.setCreateName(this.file.getName());
                        if (img != null) {
                            UploadMusicMMMonitor.this.getScreen().musicFileImage = img;
                        }
                        UploadMusicMMMonitor.this.insMonitor(UploadMusicMMMonitor.this.getParentType());
                    });
                }
            }
            catch (InterruptedException url) {
            }
            catch (Exception e) {
                UploadMusicMMMonitor.this.UPLOAD_ERROR_TEXT = new class_2588("imp.text.fileUpload.error", new Object[]{e.getLocalizedMessage()});
                e.printStackTrace();
            }
        }
    }
}

