/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.loader;

import dev.felnull.imp.client.music.loader.IMusicLoader;
import dev.felnull.imp.client.music.loader.LavaPlayerMusicLoader;
import dev.felnull.imp.client.music.loader.YoutubeDownloaderMusicLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class IMPMusicLoaders {
    protected static final Map<class_2960, IMusicLoader> LOADERS = new LinkedHashMap<class_2960, IMusicLoader>();
    public static final class_2960 LAVA_YOUTUBE = new class_2960("iammusicplayer", "lava_youtube");
    public static final class_2960 YOUTUBE_DOWNLOADER = new class_2960("iammusicplayer", "youtube_downloader");
    public static final class_2960 LAVA_SOUNDCLOUD = new class_2960("iammusicplayer", "lava_soundcloud");
    public static final class_2960 LAVA_HTTP = new class_2960("iammusicplayer", "lava_http");

    public static void init() {
        IMPMusicLoaders.registerLoader(YOUTUBE_DOWNLOADER, new YoutubeDownloaderMusicLoader());
        IMPMusicLoaders.registerLoader(LAVA_YOUTUBE, new LavaPlayerMusicLoader("youtube"));
        IMPMusicLoaders.registerLoader(LAVA_HTTP, new LavaPlayerMusicLoader("http"));
    }

    public static void registerLoader(class_2960 location, IMusicLoader loader) {
        LOADERS.put(location, loader);
    }

    public static IMusicLoader getLoader(class_2960 location) {
        return LOADERS.get(location);
    }

    public static List<IMusicLoader> getLoaders() {
        return new ArrayList<IMusicLoader>(LOADERS.values());
    }
}

