/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.github.kiulian.downloader.model.videos;

import dev.felnull.imp.libs.com.github.kiulian.downloader.model.Filter;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.videos.VideoDetails;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.videos.formats.AudioFormat;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.videos.formats.Format;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.videos.formats.VideoFormat;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.videos.formats.VideoWithAudioFormat;
import java.util.LinkedList;
import java.util.List;

public class VideoInfo {
    private final VideoDetails videoDetails;
    private final List<Format> formats;
    private final List<SubtitlesInfo> subtitlesInfo;

    public VideoInfo(VideoDetails videoDetails, List<Format> formats, List<SubtitlesInfo> subtitlesInfo) {
        this.videoDetails = videoDetails;
        this.formats = formats;
        this.subtitlesInfo = subtitlesInfo;
    }

    public VideoDetails details() {
        return this.videoDetails;
    }

    public List<Format> formats() {
        return this.formats;
    }

    public List<SubtitlesInfo> subtitlesInfo() {
        return this.subtitlesInfo;
    }

    public List<Format> findFormats(Filter<Format> filter) {
        return filter.select(this.formats);
    }

    public Format findFormatByItag(int itag) {
        for (Format format : this.formats) {
            if (format.itag().id() != itag) continue;
            return format;
        }
        return null;
    }

    public List<VideoWithAudioFormat> videoWithAudioFormats() {
        LinkedList<VideoWithAudioFormat> find = new LinkedList<VideoWithAudioFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof VideoWithAudioFormat)) continue;
            find.add((VideoWithAudioFormat)format);
        }
        return find;
    }

    public VideoFormat bestVideoWithAudioFormat() {
        VideoFormat bestFormat = null;
        for (Format format : this.formats) {
            if (!(format instanceof VideoWithAudioFormat)) continue;
            VideoFormat videoFormat = (VideoFormat)format;
            if (bestFormat != null && videoFormat.videoQuality().compare(bestFormat.videoQuality()) <= 0) continue;
            bestFormat = videoFormat;
        }
        return bestFormat;
    }

    public List<VideoFormat> videoFormats() {
        LinkedList<VideoFormat> find = new LinkedList<VideoFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof VideoFormat)) continue;
            find.add((VideoFormat)format);
        }
        return find;
    }

    public VideoFormat bestVideoFormat() {
        VideoFormat bestFormat = null;
        for (Format format : this.formats) {
            if (!(format instanceof VideoFormat)) continue;
            VideoFormat videoFormat = (VideoFormat)format;
            if (bestFormat != null && videoFormat.videoQuality().compare(bestFormat.videoQuality()) <= 0) continue;
            bestFormat = videoFormat;
        }
        return bestFormat;
    }

    public List<AudioFormat> audioFormats() {
        LinkedList<AudioFormat> find = new LinkedList<AudioFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof AudioFormat)) continue;
            find.add((AudioFormat)format);
        }
        return find;
    }

    public AudioFormat bestAudioFormat() {
        AudioFormat bestFormat = null;
        for (Format format : this.formats) {
            if (!(format instanceof AudioFormat)) continue;
            AudioFormat audioFormat = (AudioFormat)format;
            if (bestFormat != null && audioFormat.audioQuality().compare(bestFormat.audioQuality()) <= 0) continue;
            bestFormat = audioFormat;
        }
        return bestFormat;
    }
}

