/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.mpatric.mp3agic;

import java.io.UnsupportedEncodingException;

public class BufferTools {
    protected static final String defaultCharsetName = "ISO-8859-1";

    public static String byteBufferToStringIgnoringEncodingIssues(byte[] byArray, int n, int n2) {
        try {
            return BufferTools.byteBufferToString(byArray, n, n2, defaultCharsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String byteBufferToString(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        return BufferTools.byteBufferToString(byArray, n, n2, defaultCharsetName);
    }

    public static String byteBufferToString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (n2 < 1) {
            return "";
        }
        return new String(byArray, n, n2, string);
    }

    public static byte[] stringToByteBufferIgnoringEncodingIssues(String string, int n, int n2) {
        try {
            return BufferTools.stringToByteBuffer(string, n, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] stringToByteBuffer(String string, int n, int n2) throws UnsupportedEncodingException {
        return BufferTools.stringToByteBuffer(string, n, n2, defaultCharsetName);
    }

    public static byte[] stringToByteBuffer(String string, int n, int n2, String string2) throws UnsupportedEncodingException {
        String string3 = string.substring(n, n + n2);
        byte[] byArray = string3.getBytes(string2);
        return byArray;
    }

    public static void stringIntoByteBuffer(String string, int n, int n2, byte[] byArray, int n3) throws UnsupportedEncodingException {
        BufferTools.stringIntoByteBuffer(string, n, n2, byArray, n3, defaultCharsetName);
    }

    public static void stringIntoByteBuffer(String string, int n, int n2, byte[] byArray, int n3, String string2) throws UnsupportedEncodingException {
        String string3 = string.substring(n, n + n2);
        byte[] byArray2 = string3.getBytes(string2);
        if (byArray2.length > 0) {
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
        }
    }

    public static String trimStringRight(String string) {
        char c;
        int n;
        for (n = string.length() - 1; n >= 0 && (c = string.charAt(n)) <= ' '; --n) {
        }
        if (n == string.length() - 1) {
            return string;
        }
        if (n < 0) {
            return "";
        }
        return string.substring(0, n + 1);
    }

    public static String padStringRight(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() < n) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean checkBit(byte by, int n) {
        return (by & 1 << n) != 0;
    }

    public static byte setBit(byte by, int n, boolean bl) {
        byte by2 = bl ? (byte)(by | 1 << n) : (byte)(by & ~(1 << n));
        return by2;
    }

    public static int shiftByte(byte by, int n) {
        int n2 = by & 0xFF;
        if (n < 0) {
            return n2 << -n;
        }
        if (n > 0) {
            return n2 >> n;
        }
        return n2;
    }

    public static int unpackInteger(byte by, byte by2, byte by3, byte by4) {
        int n = by4 & 0xFF;
        n += BufferTools.shiftByte(by3, -8);
        n += BufferTools.shiftByte(by2, -16);
        return n += BufferTools.shiftByte(by, -24);
    }

    public static byte[] packInteger(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[0] = (byte)(n >> 24 & 0xFF);
        return byArray;
    }

    public static int unpackSynchsafeInteger(byte by, byte by2, byte by3, byte by4) {
        int n = by4 & 0x7F;
        n += BufferTools.shiftByte((byte)(by3 & 0x7F), -7);
        n += BufferTools.shiftByte((byte)(by2 & 0x7F), -14);
        return n += BufferTools.shiftByte((byte)(by & 0x7F), -21);
    }

    public static byte[] packSynchsafeInteger(int n) {
        byte[] byArray = new byte[4];
        BufferTools.packSynchsafeInteger(n, byArray, 0);
        return byArray;
    }

    public static void packSynchsafeInteger(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)(n & 0x7F);
        byArray[n2 + 2] = (byte)(n >> 7 & 0x7F);
        byArray[n2 + 1] = (byte)(n >> 14 & 0x7F);
        byArray[n2 + 0] = (byte)(n >> 21 & 0x7F);
    }

    public static byte[] copyBuffer(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        if (n2 > 0) {
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        return byArray2;
    }

    public static void copyIntoByteBuffer(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 > 0) {
            System.arraycopy(byArray, n, byArray2, n3, n2);
        }
    }

    public static int sizeUnsynchronisationWouldAdd(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            if (byArray[i] != -1 || (byArray[i + 1] & 0xFFFFFFE0) != -32 && byArray[i + 1] != 0) continue;
            ++n;
        }
        if (byArray.length > 0 && byArray[byArray.length - 1] == -1) {
            ++n;
        }
        return n;
    }

    public static byte[] unsynchroniseBuffer(byte[] byArray) {
        int n = BufferTools.sizeUnsynchronisationWouldAdd(byArray);
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + n];
        int n2 = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            byArray2[n2++] = byArray[i];
            if (byArray[i] != -1 || (byArray[i + 1] & 0xFFFFFFE0) != -32 && byArray[i + 1] != 0) continue;
            byArray2[n2++] = 0;
        }
        byArray2[n2++] = byArray[byArray.length - 1];
        if (byArray[byArray.length - 1] == -1) {
            byArray2[n2++] = 0;
        }
        return byArray2;
    }

    public static int sizeSynchronisationWouldSubtract(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length - 2; ++i) {
            if (byArray[i] != -1 || byArray[i + 1] != 0 || (byArray[i + 2] & 0xFFFFFFE0) != -32 && byArray[i + 2] != 0) continue;
            ++n;
        }
        if (byArray.length > 1 && byArray[byArray.length - 2] == -1 && byArray[byArray.length - 1] == 0) {
            ++n;
        }
        return n;
    }

    public static byte[] synchroniseBuffer(byte[] byArray) {
        int n = BufferTools.sizeSynchronisationWouldSubtract(byArray);
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        int n2 = 0;
        for (int i = 0; i < byArray2.length - 1; ++i) {
            byArray2[i] = byArray[n2];
            if (byArray[n2] == -1 && byArray[n2 + 1] == 0 && ((byArray[n2 + 2] & 0xFFFFFFE0) == -32 || byArray[n2 + 2] == 0)) {
                ++n2;
            }
            ++n2;
        }
        byArray2[byArray2.length - 1] = byArray[n2];
        return byArray2;
    }

    public static String substitute(String string, String string2, String string3) {
        if (string2.length() < 1 || !string.contains(string2)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n2)) >= 0) {
            if (n2 > n) {
                stringBuilder.append(string.substring(n, n2));
            }
            if (string3 != null) {
                stringBuilder.append(string3);
            }
            n = n2 + string2.length();
            ++n2;
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    public static String asciiOnly(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '~') {
                stringBuilder.append('?');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int indexOfTerminator(byte[] byArray) {
        return BufferTools.indexOfTerminator(byArray, 0);
    }

    public static int indexOfTerminator(byte[] byArray, int n) {
        return BufferTools.indexOfTerminator(byArray, 0, 1);
    }

    public static int indexOfTerminator(byte[] byArray, int n, int n2) {
        int n3 = -1;
        for (int i = n; i <= byArray.length - n2; ++i) {
            int n4;
            if ((i - n) % n2 != 0) continue;
            for (n4 = 0; n4 < n2 && byArray[i + n4] == 0; ++n4) {
            }
            if (n4 != n2) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public static int indexOfTerminatorForEncoding(byte[] byArray, int n, int n2) {
        int n3 = n2 == 1 || n2 == 2 ? 2 : 1;
        return BufferTools.indexOfTerminator(byArray, n, n3);
    }
}

