/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska.format;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElementType;

public class MatroskaElement {
    protected final int level;
    protected long id;
    protected MatroskaElementType type;
    protected long position;
    protected int headerSize;
    protected int dataSize;

    protected MatroskaElement(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public long getId() {
        return this.id;
    }

    public MatroskaElementType getType() {
        return this.type;
    }

    public long getPosition() {
        return this.position;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public boolean is(MatroskaElementType type) {
        return type.id == this.id;
    }

    public boolean is(MatroskaElementType.DataType dataType) {
        return dataType == this.type.dataType;
    }

    public long getRemaining(long currentPosition) {
        return this.position + (long)this.headerSize + (long)this.dataSize - currentPosition;
    }

    public long getDataPosition() {
        return this.position + (long)this.headerSize;
    }

    public MatroskaElement frozen() {
        MatroskaElement element = new MatroskaElement(this.level);
        element.id = this.id;
        element.type = this.type;
        element.position = this.position;
        element.headerSize = this.headerSize;
        element.dataSize = this.dataSize;
        return element;
    }
}

