/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.equalizer;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.equalizer.EqualizerConfiguration;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import java.util.Arrays;

public class Equalizer
extends EqualizerConfiguration
implements FloatPcmAudioFilter {
    public static final int BAND_COUNT = 15;
    private static final int SAMPLE_RATE = 48000;
    private final ChannelProcessor[] channels;
    private final FloatPcmAudioFilter next;
    private static final Coefficients[] coefficients48000 = new Coefficients[]{new Coefficients(0.9984755f, 7.622667E-4f, 1.9984648f), new Coefficients(0.9975619f, 0.0012190767f, 1.9975345f), new Coefficients(0.9961626f, 0.0019186931f, 1.9960947f), new Coefficients(0.9939158f, 0.0030421072f, 1.993745f), new Coefficients(0.9902831f, 0.004858464f, 1.9898466f), new Coefficients(0.984859f, 0.0075705135f, 1.9837962f), new Coefficients(0.97588515f, 0.012057437f, 1.9731772f), new Coefficients(0.9622852f, 0.018857392f, 1.9556165f), new Coefficients(0.9408093f, 0.029595334f, 1.9242054f), new Coefficients(0.90702057f, 0.046489704f, 1.8653476f), new Coefficients(0.85868007f, 0.07065998f, 1.7600402f), new Coefficients(0.7840961f, 0.10795195f, 1.5450726f), new Coefficients(0.6833286f, 0.1583357f, 1.1426448f), new Coefficients(0.5526752f, 0.2236624f, 0.4018619f), new Coefficients(0.4181189f, 0.29094055f, -0.7090594f)};

    public Equalizer(int channelCount, FloatPcmAudioFilter next, float[] bandMultipliers) {
        super(bandMultipliers);
        this.channels = Equalizer.createProcessors(channelCount, bandMultipliers);
        this.next = next;
    }

    public Equalizer(int channelCount, FloatPcmAudioFilter next) {
        this(channelCount, next, new float[15]);
    }

    public static boolean isCompatible(AudioDataFormat format) {
        return format.sampleRate == 48000;
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        for (int channelIndex = 0; channelIndex < this.channels.length; ++channelIndex) {
            this.channels[channelIndex].process(input[channelIndex], offset, offset + length);
        }
        this.next.process(input, offset, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        for (int channelIndex = 0; channelIndex < this.channels.length; ++channelIndex) {
            this.channels[channelIndex].reset();
        }
    }

    @Override
    public void flush() throws InterruptedException {
    }

    @Override
    public void close() {
    }

    private static ChannelProcessor[] createProcessors(int channelCount, float[] bandMultipliers) {
        ChannelProcessor[] processors = new ChannelProcessor[channelCount];
        for (int i = 0; i < channelCount; ++i) {
            processors[i] = new ChannelProcessor(bandMultipliers);
        }
        return processors;
    }

    private static class Coefficients {
        private final float beta;
        private final float alpha;
        private final float gamma;

        private Coefficients(float beta, float alpha, float gamma) {
            this.beta = beta;
            this.alpha = alpha;
            this.gamma = gamma;
        }
    }

    private static class ChannelProcessor {
        private final float[] history = new float[90];
        private final float[] bandMultipliers;
        private int current;
        private int minusOne;
        private int minusTwo;

        private ChannelProcessor(float[] bandMultipliers) {
            this.bandMultipliers = bandMultipliers;
            this.current = 0;
            this.minusOne = 2;
            this.minusTwo = 1;
        }

        private void process(float[] samples, int startIndex, int endIndex) {
            for (int sampleIndex = startIndex; sampleIndex < endIndex; ++sampleIndex) {
                float sample = samples[sampleIndex];
                float result = sample * 0.25f;
                for (int bandIndex = 0; bandIndex < 15; ++bandIndex) {
                    int x = bandIndex * 6;
                    int y = x + 3;
                    Coefficients coefficients = coefficients48000[bandIndex];
                    float bandResult = coefficients.alpha * (sample - this.history[x + this.minusTwo]) + coefficients.gamma * this.history[y + this.minusOne] - coefficients.beta * this.history[y + this.minusTwo];
                    this.history[x + this.current] = sample;
                    this.history[y + this.current] = bandResult;
                    result += bandResult * this.bandMultipliers[bandIndex];
                }
                samples[sampleIndex] = Math.min(Math.max(result * 4.0f, -1.0f), 1.0f);
                if (++this.current == 3) {
                    this.current = 0;
                }
                if (++this.minusOne == 3) {
                    this.minusOne = 0;
                }
                if (++this.minusTwo != 3) continue;
                this.minusTwo = 0;
            }
        }

        private void reset() {
            Arrays.fill(this.history, 0.0f);
        }
    }
}

