/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSignatureResolver;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackJsonData;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.format.LegacyAdaptiveFormatsExtractor;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.format.LegacyDashMpdFormatsExtractor;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.format.LegacyStreamMapFormatsExtractor;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.format.StreamingDataFormatsExtractor;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.format.YoutubeTrackFormatExtractor;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.Units;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.libs.org.slf4j.Logger;
import dev.felnull.imp.libs.org.slf4j.LoggerFactory;
import java.util.List;

public class DefaultYoutubeTrackDetails
implements YoutubeTrackDetails {
    private static final Logger log = LoggerFactory.getLogger(DefaultYoutubeTrackDetails.class);
    private static final YoutubeTrackFormatExtractor[] FORMAT_EXTRACTORS = new YoutubeTrackFormatExtractor[]{new LegacyAdaptiveFormatsExtractor(), new StreamingDataFormatsExtractor(), new LegacyDashMpdFormatsExtractor(), new LegacyStreamMapFormatsExtractor()};
    private final String videoId;
    private final YoutubeTrackJsonData data;

    public DefaultYoutubeTrackDetails(String videoId, YoutubeTrackJsonData data) {
        this.videoId = videoId;
        this.data = data;
    }

    @Override
    public AudioTrackInfo getTrackInfo() {
        return this.loadTrackInfo();
    }

    @Override
    public List<YoutubeTrackFormat> getFormats(HttpInterface httpInterface, YoutubeSignatureResolver signatureResolver) {
        try {
            return this.loadTrackFormats(httpInterface, signatureResolver);
        }
        catch (Exception e) {
            throw ExceptionTools.toRuntimeException(e);
        }
    }

    @Override
    public String getPlayerScript() {
        return this.data.playerScriptUrl;
    }

    private List<YoutubeTrackFormat> loadTrackFormats(HttpInterface httpInterface, YoutubeSignatureResolver signatureResolver) {
        for (YoutubeTrackFormatExtractor extractor : FORMAT_EXTRACTORS) {
            List<YoutubeTrackFormat> formats = extractor.extract(this.data, httpInterface, signatureResolver);
            if (formats.isEmpty()) continue;
            return formats;
        }
        log.warn("Video {} with no detected format field, response {} polymer {}", this.videoId, this.data.playerResponse.format(), this.data.polymerArguments.format());
        throw new FriendlyException("Unable to play this YouTube track.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("No track formats found."));
    }

    private AudioTrackInfo loadTrackInfo() {
        JsonBrowser playabilityStatus = this.data.playerResponse.get("playabilityStatus");
        if ("ERROR".equals(playabilityStatus.get("status").text())) {
            throw new FriendlyException(playabilityStatus.get("reason").text(), FriendlyException.Severity.COMMON, null);
        }
        JsonBrowser videoDetails = this.data.playerResponse.get("videoDetails");
        if (videoDetails.isNull()) {
            return this.loadLegacyTrackInfo();
        }
        TemporalInfo temporalInfo = TemporalInfo.fromRawData(videoDetails.get("isLiveContent").asBoolean(false), videoDetails.get("lengthSeconds"));
        return this.buildTrackInfo(this.videoId, videoDetails.get("title").text(), videoDetails.get("author").text(), temporalInfo);
    }

    private AudioTrackInfo loadLegacyTrackInfo() {
        JsonBrowser args = this.data.polymerArguments;
        if ("fail".equals(args.get("status").text())) {
            throw new FriendlyException(args.get("reason").text(), FriendlyException.Severity.COMMON, null);
        }
        TemporalInfo temporalInfo = TemporalInfo.fromRawData("1".equals(args.get("live_playback").text()), args.get("length_seconds"));
        return this.buildTrackInfo(this.videoId, args.get("title").text(), args.get("author").text(), temporalInfo);
    }

    private AudioTrackInfo buildTrackInfo(String videoId, String title, String uploader, TemporalInfo temporalInfo) {
        return new AudioTrackInfo(title, uploader, temporalInfo.durationMillis, videoId, temporalInfo.isActiveStream, "https://www.youtube.com/watch?v=" + videoId);
    }

    private static class TemporalInfo {
        public final boolean isActiveStream;
        public final long durationMillis;

        private TemporalInfo(boolean isActiveStream, long durationMillis) {
            this.isActiveStream = isActiveStream;
            this.durationMillis = durationMillis;
        }

        public static TemporalInfo fromRawData(boolean wasLiveStream, JsonBrowser durationSecondsField) {
            long durationValue = durationSecondsField.asLong(0L);
            boolean isActiveStream = wasLiveStream && durationValue == 0L;
            return new TemporalInfo(isActiveStream, durationValue == 0L ? Long.MAX_VALUE : Units.secondsToMillis(durationValue));
        }
    }
}

