/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.libs.org.apache.commons.io.IOUtils;
import dev.felnull.imp.libs.org.slf4j.Logger;
import dev.felnull.imp.libs.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TrustManagerBuilder {
    private static final Logger log = LoggerFactory.getLogger(TrustManagerBuilder.class);
    private final List<Certificate> certificates = new ArrayList<Certificate>();

    public TrustManagerBuilder addBuiltinCertificates() throws Exception {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        X509TrustManager builtInTrustManager = this.findFirstX509TrustManager(factory);
        if (builtInTrustManager != null) {
            this.addFromTrustManager(builtInTrustManager);
        }
        return this;
    }

    public TrustManagerBuilder addFromResourceDirectory(String path) throws Exception {
        this.addFromResourceList(path, path + "/bundled.txt");
        this.addFromResourceList(path, path + "/extended.txt");
        return this;
    }

    public X509TrustManager build() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        for (int i = 0; i < this.certificates.size(); ++i) {
            keyStore.setCertificateEntry(String.valueOf(i), this.certificates.get(i));
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        return this.findFirstX509TrustManager(factory);
    }

    private X509TrustManager findFirstX509TrustManager(TrustManagerFactory factory) {
        for (TrustManager trustManager : factory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    private void addFromTrustManager(X509TrustManager trustManager) {
        for (X509Certificate certificate : trustManager.getAcceptedIssuers()) {
            this.certificates.add(certificate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFromResourceList(String basePath, String listPath) throws Exception {
        InputStream listFileStream = TrustManagerBuilder.class.getResourceAsStream(listPath);
        if (listFileStream == null) {
            log.debug("Certificate list {} not present in classpath.", (Object)listPath);
            return;
        }
        try {
            for (String line : IOUtils.readLines(listFileStream, StandardCharsets.UTF_8)) {
                String fileName = line.trim();
                if (fileName.isEmpty()) continue;
                this.addFromResourceFile(basePath + "/" + fileName);
            }
        }
        finally {
            ExceptionTools.closeWithWarnings(listFileStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFromResourceFile(String resourcePath) throws Exception {
        InputStream fileStream = TrustManagerBuilder.class.getResourceAsStream(resourcePath);
        if (fileStream == null) {
            log.warn("Certificate {} not present in classpath.", (Object)resourcePath);
            return;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(fileStream, null);
            this.addFromKeyStore(keyStore);
        }
        finally {
            ExceptionTools.closeWithWarnings(fileStream);
        }
    }

    private void addFromKeyStore(KeyStore keyStore) throws Exception {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            this.certificates.add(keyStore.getCertificate(alias));
        }
    }
}

