/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.dev.felnull.fnjl.math;

import dev.felnull.imp.libs.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.imp.libs.dev.felnull.fnjl.math.FNVec2i;
import java.util.Objects;

public class FNVec2f {
    private float x;
    private float y;

    public FNVec2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public double distance(FNVec2i vec) {
        return Math.sqrt(Math.pow(this.x - (float)vec.getX(), 2.0) + Math.pow(this.y - (float)vec.getY(), 2.0));
    }

    public FNVec2f add(FNVec2f vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        return this;
    }

    public FNVec2f sub(FNVec2f vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        return this;
    }

    public String toString() {
        return "FNVec2f{x=" + this.x + ", y=" + this.y + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec2f fnVec2f = (FNVec2f)o;
        return Float.compare(fnVec2f.x, this.x) == 0 && Float.compare(fnVec2f.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public FNVec2d convertDouble() {
        return new FNVec2d(this.x, this.y);
    }

    public FNVec2i convertInt() {
        return new FNVec2i((int)this.x, (int)this.y);
    }
}

