/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.tuple.Pair;

public class MusicRing {
    private final class_3218 level;
    private final Map<UUID, IMusicRinger> ringers = new HashMap<UUID, IMusicRinger>();
    private final Map<UUID, RingedPlayerInfos> playerInfos = new HashMap<UUID, RingedPlayerInfos>();
    private final Set<UUID> waitRingers = new HashSet<UUID>();
    private long baseTime;
    private long pauseTime;
    private long lastTime;

    public MusicRing(class_3218 level) {
        this.level = level;
        this.baseTime = System.currentTimeMillis();
    }

    private class_3218 getLevel() {
        return this.level;
    }

    protected void tick(class_3218 level) {
        if (level != this.getLevel()) {
            return;
        }
        for (IMusicRinger value : this.ringers.values()) {
            RingedPlayerInfos pr;
            if (!value.isRingerExist()) {
                this.stop(value.getRingerUUID());
                break;
            }
            MusicSource ms = value.getRingerMusicSource();
            boolean stopFlg = false;
            if (ms == null) {
                if (value.isRingerPlaying()) {
                    value.setRingerPlaying(false);
                }
                stopFlg = true;
            } else if (value.isRingerPlaying()) {
                pr = this.playerInfos.get(value.getRingerUUID());
                if (pr == null) {
                    pr = new RingedPlayerInfos(value.getRingerUUID(), this.getTime());
                    pr.sendFirstPackets();
                    this.playerInfos.put(value.getRingerUUID(), pr);
                    this.waitRingers.add(value.getRingerUUID());
                }
            } else {
                stopFlg = true;
            }
            if ((pr = this.playerInfos.get(value.getRingerUUID())) == null) continue;
            if (stopFlg) {
                pr.depose();
                this.playerInfos.remove(value.getRingerUUID());
                this.waitRingers.remove(value.getRingerUUID());
                continue;
            }
            if (!pr.tick(this.getTime())) continue;
            this.waitRingers.remove(value.getRingerUUID());
            long eq = this.getTime() - this.lastTime;
            if (ms.getDuration() >= value.getRingerPosition() + eq || value.isRingerStream()) {
                value.setRingerPosition(value.getRingerPosition() + eq);
                continue;
            }
            value.setRingerPosition(0L);
            value.ringerEnd();
            if (value.isRingerLoop()) {
                pr.depose();
                this.playerInfos.remove(value.getRingerUUID());
                continue;
            }
            value.setRingerPlaying(false);
        }
        this.lastTime = this.getTime();
    }

    protected boolean isWaitRinger(UUID uuid) {
        return this.waitRingers.contains(uuid);
    }

    protected void addRinger(IMusicRinger ringer) {
        if (!this.ringers.containsKey(ringer.getRingerUUID())) {
            this.ringers.put(ringer.getRingerUUID(), ringer);
        }
    }

    public Map<UUID, IMusicRinger> getRingers() {
        return this.ringers;
    }

    protected void pause() {
        this.pauseTime = System.currentTimeMillis();
    }

    protected void resume() {
        this.baseTime += System.currentTimeMillis() - this.pauseTime;
        this.pauseTime = 0L;
    }

    private long getTime() {
        return System.currentTimeMillis() - this.baseTime;
    }

    protected void depose() {
        this.ringers.clear();
        this.playerInfos.clear();
        this.waitRingers.clear();
    }

    protected void restart(UUID uuid) {
        IMusicRinger ringer = this.ringers.get(uuid);
        if (ringer != null) {
            this.stop(uuid);
            this.addRinger(ringer);
        }
    }

    protected void stop(UUID uuid) {
        this.ringers.remove(uuid);
        RingedPlayerInfos pr = this.playerInfos.get(uuid);
        if (pr != null) {
            pr.depose();
        }
        this.playerInfos.remove(uuid);
        this.waitRingers.remove(uuid);
    }

    private MusicPlaybackInfo getPlaybackInfo(IMusicRinger ringer) {
        Pair<class_2960, class_2487> tr = ringer.getRingerTracker();
        return new MusicPlaybackInfo((class_2960)tr.getKey(), (class_2487)tr.getValue(), ringer.isRingerMute() ? 0.0f : ringer.getRingerVolume(), ringer.isRingerMute() ? 0.0f : ringer.getRingerRange());
    }

    protected void onUpdate(class_3222 player, UUID uuid, UUID waitUUID, int state) {
        RingedPlayerInfos pr = this.playerInfos.get(uuid);
        if (pr != null && pr.waitUUID.equals(waitUUID)) {
            pr.responseUpdate(player, state);
        }
    }

    protected void addReadyPlayer(class_3222 player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        RingedPlayerInfos pr = this.playerInfos.get(uuid);
        if (pr != null && pr.waitUUID.equals(waitUUID)) {
            pr.addReadyPlayer(player, result, retry, elapsed);
        }
    }

    public static long getMaxWaitTime() {
        return IamMusicPlayer.CONFIG.maxWaitTime;
    }

    public static long getRetryTime() {
        return IamMusicPlayer.CONFIG.retryTime;
    }

    private class RingedPlayerInfos {
        private final UUID uuid;
        private final UUID waitUUID = UUID.randomUUID();
        private final List<UUID> firstWaitPlayers = new ArrayList<UUID>();
        private final List<UUID> firstReadyPlayers = new ArrayList<UUID>();
        private final List<UUID> listenPlayers = new ArrayList<UUID>();
        private final List<UUID> middleLoadPlayers = new ArrayList<UUID>();
        private final Map<UUID, Long> failurePlayers = new HashMap<UUID, Long>();
        private final long startTime;
        private boolean notWait;

        public RingedPlayerInfos(UUID uuid, long startTime) {
            this.uuid = uuid;
            this.startTime = startTime;
            this.firstWaitPlayers.addAll(MusicRing.this.getLevel().method_18456().stream().filter(n -> this.canListen((class_1657)n)).map(n -> n.method_7334().getId()).toList());
        }

        private void sendFirstPackets() {
            for (UUID firstWaitPlayer : this.firstWaitPlayers) {
                class_1657 class_16572 = MusicRing.this.getLevel().method_18470(firstWaitPlayer);
                if (!(class_16572 instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_READY, (class_2540)new IMPPackets.MusicReadyMessage(this.waitUUID, this.uuid, this.getRinger().getRingerMusicSource(), MusicRing.this.getPlaybackInfo(this.getRinger()), this.getRingerPosition()).toFBB());
            }
        }

        private void sendStopPackets(UUID player) {
            class_1657 class_16572 = MusicRing.this.getLevel().method_18470(player);
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.uuid, this.waitUUID, 1).toFBB());
            }
        }

        private void sendMiddleStartPacket(UUID player) {
            class_1657 class_16572 = MusicRing.this.getLevel().method_18470(player);
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_READY, (class_2540)new IMPPackets.MusicReadyMessage(this.waitUUID, this.uuid, this.getRinger().getRingerMusicSource(), MusicRing.this.getPlaybackInfo(this.getRinger()), this.getRingerPosition()).toFBB());
                this.advancement(serverPlayer);
            }
        }

        private long getRingerPosition() {
            if (this.getRinger().isRingerStream()) {
                return 0L;
            }
            return this.getRinger().getRingerPosition();
        }

        private void addReadyPlayer(class_3222 player, boolean result, boolean retry, long elapsed) {
            UUID id = player.method_7334().getId();
            if (this.notWait) {
                if (this.middleLoadPlayers.contains(id)) {
                    if (result) {
                        NetworkManager.sendToPlayer((class_3222)player, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.uuid, this.waitUUID, 0, elapsed, MusicPlaybackInfo.EMPTY).toFBB());
                        this.listenPlayers.add(id);
                    } else {
                        this.failurePlayers.put(id, System.currentTimeMillis());
                    }
                    this.middleLoadPlayers.remove(id);
                }
            } else {
                if (result) {
                    this.listenPlayers.add(id);
                    this.firstReadyPlayers.add(id);
                } else {
                    this.failurePlayers.put(id, System.currentTimeMillis());
                }
                this.firstWaitPlayers.remove(id);
            }
        }

        private void startReadyWaitPlayers() {
            for (UUID pl : this.firstReadyPlayers) {
                class_1657 class_16572 = MusicRing.this.getLevel().method_18470(pl);
                if (!(class_16572 instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.uuid, this.waitUUID, 0).toFBB());
                this.advancement(serverPlayer);
            }
        }

        private void responseUpdate(class_3222 player, int state) {
            UUID id = player.method_7334().getId();
            if (this.listenPlayers.contains(id) && state != 1) {
                this.listenPlayers.remove(id);
            }
            if (this.middleLoadPlayers.contains(id) && state != 2) {
                this.middleLoadPlayers.remove(id);
            }
        }

        private void sendUpdate() {
            class_3222 serverPlayer;
            class_1657 class_16572;
            for (UUID player : this.listenPlayers) {
                class_16572 = MusicRing.this.getLevel().method_18470(player);
                if (!(class_16572 instanceof class_3222)) continue;
                serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.uuid, this.waitUUID, 2, 0L, MusicRing.this.getPlaybackInfo(this.getRinger())).toFBB());
            }
            for (UUID player : this.middleLoadPlayers) {
                class_16572 = MusicRing.this.getLevel().method_18470(player);
                if (!(class_16572 instanceof class_3222)) continue;
                serverPlayer = (class_3222)class_16572;
                NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_2960)IMPPackets.MUSIC_RING_STATE, (class_2540)new IMPPackets.MusicRingStateMessage(this.uuid, this.waitUUID, 2, 0L, MusicRing.this.getPlaybackInfo(this.getRinger())).toFBB());
            }
        }

        private boolean tick(long currentTime) {
            if (this.notWait) {
                ArrayList<UUID> nl = new ArrayList<UUID>();
                for (class_3222 player : MusicRing.this.getLevel().method_18456()) {
                    UUID id;
                    if (!this.canListen((class_1657)player) || this.isFailureCoolDown(id = player.method_7334().getId())) continue;
                    nl.add(id);
                    if (this.listenPlayers.contains(id) || this.middleLoadPlayers.contains(id)) continue;
                    this.sendMiddleStartPacket(id);
                    this.middleLoadPlayers.add(id);
                }
                for (UUID listenPlayer : this.listenPlayers) {
                    if (nl.contains(listenPlayer)) continue;
                    this.sendStopPackets(listenPlayer);
                }
                for (UUID middleLoadPlayer : this.middleLoadPlayers) {
                    if (nl.contains(middleLoadPlayer)) continue;
                    this.sendStopPackets(middleLoadPlayer);
                }
                this.listenPlayers.clear();
                this.listenPlayers.addAll(nl.stream().filter(n -> !this.middleLoadPlayers.contains(n)).toList());
                this.middleLoadPlayers.clear();
                this.middleLoadPlayers.addAll(nl.stream().filter(n -> !this.listenPlayers.contains(n)).toList());
                this.sendUpdate();
                return true;
            }
            if (this.canPlayPlayersCheck(currentTime)) {
                this.startReadyWaitPlayers();
                this.notWait = true;
                return true;
            }
            return false;
        }

        private boolean isFailureCoolDown(UUID uuid) {
            Long fr = this.failurePlayers.get(uuid);
            if (fr != null) {
                return System.currentTimeMillis() - fr <= MusicRing.getRetryTime();
            }
            return false;
        }

        private boolean canPlayPlayersCheck(long currentTime) {
            long eq = currentTime - this.startTime;
            if (eq > MusicRing.getMaxWaitTime()) {
                return true;
            }
            ArrayList<UUID> removes = new ArrayList<UUID>();
            for (UUID waiter : this.firstWaitPlayers) {
                class_1657 pl = MusicRing.this.getLevel().method_18470(waiter);
                if (pl != null && this.canListen(pl)) continue;
                removes.add(waiter);
            }
            this.firstWaitPlayers.removeAll(removes);
            return this.firstWaitPlayers.isEmpty();
        }

        private void advancement(class_3222 player) {
            IMPCriteriaTriggers.LISTEN_TO_MUSIC.trigger(player, this.getRinger().isRingerStream(), this.getRinger().isRingerRemote(), this.isKamesuta());
        }

        private boolean isKamesuta() {
            String ath = this.getRinger().getRingerMusicAuthor();
            return this.getRinger().getRingerAntenna().method_7964().getString().equalsIgnoreCase("kamesuta") && ath != null && (ath.equalsIgnoreCase("kamesuta") || ath.equalsIgnoreCase("\u304b\u3081\u3059\u305f") || ath.equalsIgnoreCase("\u30ab\u30e1\u30b9\u30bf"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean canListen(class_1657 player) {
            if (player.field_6002 != MusicRing.this.getLevel()) return false;
            double d = Math.sqrt(player.method_5707(this.getRinger().getRingerSpatialPosition()));
            float f = this.getRinger().isRingerMute() ? 0.0f : this.getRinger().getRingerRange() + 30.0f;
            if (!(d <= (double)f)) return false;
            return true;
        }

        private IMusicRinger getRinger() {
            return MusicRing.this.ringers.get(this.uuid);
        }

        private void depose() {
            for (UUID listenPlayer : this.listenPlayers) {
                this.sendStopPackets(listenPlayer);
            }
            for (UUID middleLoadPlayer : this.middleLoadPlayers) {
                this.sendStopPackets(middleLoadPlayer);
            }
        }
    }
}

