/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.block;

import dev.architectury.registry.registries.DeferredRegister;
import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.CassetteDeckBlock;
import dev.felnull.imp.block.MusicManagerBlock;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.item.IMPCreativeModeTab;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public class IMPBlocks {
    private static final Map<Block, Item> BLOCK_BY_ITEM = new HashMap<Block, Item>();
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"iammusicplayer", (ResourceKey)Registry.f_122901_);
    private static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((String)"iammusicplayer", (ResourceKey)Registry.f_122904_);
    public static final Block MUSIC_MANAGER = IMPBlocks.register("music_manager", (Block)new MusicManagerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60999_().m_60978_(3.0f).m_60999_()));
    public static final Block CASSETTE_DECK = IMPBlocks.register("cassette_deck", (Block)new CassetteDeckBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60999_().m_60978_(3.0f).m_60999_()));
    public static final Block BOOMBOX = IMPBlocks.register("boombox", (Block)new BoomboxBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(3.0f)), n -> new BoomboxItem((Block)n, new Item.Properties().m_41491_(IMPCreativeModeTab.MOD_TAB).m_41487_(1)));

    private static Block register(String name, Block block) {
        return IMPBlocks.register(name, block, n -> new BlockItem(n, new Item.Properties().m_41491_(IMPCreativeModeTab.MOD_TAB)));
    }

    private static Block register(String name, Block block, Function<Block, Item> blockItem) {
        BLOCKS.register(name, () -> block);
        Item item = blockItem.apply(block);
        BLOCK_ITEMS.register(name, () -> item);
        BLOCK_BY_ITEM.put(block, item);
        return block;
    }

    public static Item getItemByBlock(Block block) {
        return BLOCK_BY_ITEM.getOrDefault(block, Items.f_41852_);
    }

    public static void init() {
        BLOCKS.register();
        BLOCK_ITEMS.register();
    }
}

