/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.blockentity;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.IMPBaseEntityBlockEntity;
import dev.felnull.imp.blockentity.IMPBlockEntitys;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.inventory.BoomboxMenu;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.imp.util.IMPItemUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class BoomboxBlockEntity
extends IMPBaseEntityBlockEntity
implements IBoomboxRinger {
    private final BoomboxData boomboxData;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final UUID ringerUUID = UUID.randomUUID();

    public BoomboxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(IMPBlockEntitys.BOOMBOX, blockPos, blockState);
        this.boomboxData = new BoomboxData(new BoomboxData.DataAccess(){

            @Override
            public ItemStack getCassetteTape() {
                return BoomboxBlockEntity.this.getCassetteTape();
            }

            @Override
            public ItemStack getAntenna() {
                return BoomboxBlockEntity.this.getAntenna();
            }

            @Override
            public boolean isPower() {
                return BoomboxBlockEntity.this.isPower();
            }

            @Override
            public void setPower(boolean power) {
                BoomboxBlockEntity.this.setPower(power);
            }

            @Override
            public IMusicRinger getRinger() {
                return BoomboxBlockEntity.this;
            }

            @Override
            public Vec3 getPosition() {
                return new Vec3((double)BoomboxBlockEntity.this.m_58899_().m_123341_(), (double)BoomboxBlockEntity.this.m_58899_().m_123342_(), (double)BoomboxBlockEntity.this.m_58899_().m_123343_());
            }

            @Override
            public void setCassetteTape(ItemStack stack) {
                BoomboxBlockEntity.this.m_6836_(0, stack);
            }

            @Override
            public void dataUpdate(BoomboxData data) {
                BoomboxBlockEntity.this.m_6596_();
            }
        });
    }

    public void setBoomboxData(BoomboxData data) {
        this.boomboxData.load(data.save(new CompoundTag(), false, false), false, false);
    }

    public ItemStack createRetainDropItem() {
        return BoomboxItem.createByBE(this, false);
    }

    public boolean isRetainDrop() {
        return true;
    }

    public boolean isRetainEmpty() {
        return false;
    }

    protected Component m_6820_() {
        return IMPBlocks.BOOMBOX.m_49954_();
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new BoomboxMenu(i, inventory, (Container)this, this.m_58899_(), ItemStack.f_41583_, null);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.boomboxData.load(tag.m_128469_("BoomBoxData"), false, false);
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        tag.m_128365_("BoomBoxData", (Tag)this.boomboxData.save(new CompoundTag(), false, false));
        return tag;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BoomboxBlockEntity blockEntity) {
        blockEntity.boomboxData.tick(level);
        if (!level.m_5776_()) {
            blockEntity.ringerTick();
            blockEntity.setRaisedHandleState(blockEntity.boomboxData.getHandleRaisedProgress() >= blockEntity.boomboxData.getHandleRaisedMax());
            blockEntity.sync();
            blockEntity.m_6596_();
        }
    }

    public CompoundTag getSyncData(ServerPlayer player, CompoundTag tag) {
        tag.m_128365_("BoomBoxData", (Tag)this.boomboxData.save(new CompoundTag(), false, true));
        return super.getSyncData(player, tag);
    }

    public void onSync(CompoundTag tag) {
        super.onSync(tag);
        this.boomboxData.load(tag.m_128469_("BoomBoxData"), false, true);
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        return i == 0 && IMPItemUtil.isCassetteTape(itemStack) || i == 1 && IMPItemUtil.isAntenna(itemStack);
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setRaisedHandleState(boolean raised) {
        BlockState bs = (BlockState)this.m_58900_().m_61124_((Property)BoomboxBlock.RAISED, (Comparable)Boolean.valueOf(raised));
        this.m_58904_().m_7731_(this.m_58899_(), bs, 2);
    }

    public BoomboxData getBoomboxData() {
        return this.boomboxData;
    }

    @Override
    public CompoundTag onInstruction(ServerPlayer player, String name, int num, CompoundTag data) {
        CompoundTag ret = this.boomboxData.onInstruction(player, name, num, data);
        if (ret != null) {
            return ret;
        }
        return super.onInstruction(player, name, num, data);
    }

    public ItemStack getCassetteTape() {
        return this.m_8020_(0);
    }

    public ItemStack getAntenna() {
        return this.m_8020_(1);
    }

    @Override
    public Component getRingerName() {
        return this.m_6820_();
    }

    @Override
    public UUID getRingerUUID() {
        return this.ringerUUID;
    }

    @Override
    public boolean isRingerExist() {
        if (this.m_58904_() == null || this.f_58857_ != this.m_58904_()) {
            return false;
        }
        return this.m_58899_() != null && this.f_58857_.m_7702_(this.m_58899_()) == this;
    }

    @Override
    @NotNull
    public BoomboxData getRingerBoomboxData() {
        return this.boomboxData;
    }

    @Override
    public ServerLevel getRingerLevel() {
        return (ServerLevel)this.f_58857_;
    }

    @Override
    public Pair<ResourceLocation, CompoundTag> getRingerTracker() {
        return Pair.of((Object)MusicRingManager.FIXED_TRACKER, (Object)MusicRingManager.createFixedTracker(this.getRingerSpatialPosition()));
    }

    @Override
    @NotNull
    public Vec3 getRingerSpatialPosition() {
        return new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
    }

    public void setByItem(ItemStack stack) {
        this.setPower(BoomboxItem.isPowerOn(stack));
        this.m_6836_(0, BoomboxItem.getCassetteTape(stack));
        this.m_6836_(1, BoomboxItem.getAntenna(stack));
        this.setBoomboxData(BoomboxItem.getData(stack));
        this.setPower(BoomboxItem.isPowerOn(stack));
        if (BoomboxItem.getTransferProgress(stack) == 0) {
            this.boomboxData.setHandleRaising(true);
            this.boomboxData.setHandleRaisedProgress(this.boomboxData.getHandleRaisedMax());
            this.boomboxData.setHandleRaisedProgressOld(this.boomboxData.getHandleRaisedMax());
        }
    }
}

