/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.blockentity;

import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.IMPBaseEntityBlockEntity;
import dev.felnull.imp.blockentity.IMPBlockEntitys;
import dev.felnull.imp.inventory.MusicManagerMenu;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MusicManagerBlockEntity
extends IMPBaseEntityBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);
    protected final Map<UUID, CompoundTag> playerData = new HashMap<UUID, CompoundTag>();
    private CompoundTag myData = new CompoundTag();

    public MusicManagerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(IMPBlockEntitys.MUSIC_MANAGER, blockPos, blockState);
    }

    protected Component m_6820_() {
        return IMPBlocks.MUSIC_MANAGER.m_49954_();
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new MusicManagerMenu(i, inventory, (Container)this, this.m_58899_());
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, MusicManagerBlockEntity blockEntity) {
        if (!level.m_5776_()) {
            blockEntity.playerData.forEach((n, m) -> {
                String monst = m.m_128461_("Monitor");
                if (!monst.isEmpty()) {
                    MonitorType type = MonitorType.getByName(monst);
                    if (blockEntity.isPower() && type == MonitorType.OFF || !blockEntity.isPower() && type != MonitorType.OFF) {
                        m.m_128359_("Monitor", MonitorType.getDefault(blockEntity, n).getName());
                    }
                    if (type == MonitorType.OFF) {
                        m.m_128473_("SelectedPlayList");
                        m.m_128473_("SelectedMusic");
                    }
                    MusicManager mm = MusicManager.getInstance();
                    if (m.m_128441_("SelectedPlayList") && (mm.getSaveData().getPlayLists().get(m.m_128342_("SelectedPlayList")) == null || !mm.getSaveData().getPlayLists().get(m.m_128342_("SelectedPlayList")).getAuthority().getAuthorityType((UUID)n).isMoreReadOnly())) {
                        m.m_128473_("SelectedPlayList");
                        m.m_128473_("SelectedMusic");
                    } else if (m.m_128441_("SelectedMusic") && !mm.getSaveData().getMusics().containsKey(m.m_128342_("SelectedMusic"))) {
                        m.m_128473_("SelectedMusic");
                    }
                    if (m.m_128441_("SelectedPlayer")) {
                        boolean rmFlg = !m.m_128441_("SelectedPlayList");
                        boolean rmFlg2 = false;
                        if (m.m_128441_("SelectedPlayList")) {
                            MusicPlayList pl = mm.getSaveData().getPlayLists().get(m.m_128342_("SelectedPlayList"));
                            rmFlg2 = pl != null ? !pl.getAuthority().getPlayersAuthority().containsKey(m.m_128342_("SelectedPlayer")) : true;
                        }
                        if (rmFlg || rmFlg2) {
                            m.m_128473_("SelectedPlayer");
                        }
                    }
                    if (type != null && type.isNeedSelectPlayList() && !m.m_128441_("SelectedPlayList")) {
                        m.m_128359_("Monitor", MonitorType.PLAY_LIST.getName());
                    }
                    if (type != null && type.isNeedSelectMusic() && !m.m_128441_("SelectedMusic")) {
                        m.m_128359_("Monitor", MonitorType.PLAY_LIST.getName());
                    }
                }
            });
            blockEntity.m_6596_();
            blockEntity.sync();
        }
    }

    private void updateMonitor(ServerPlayer player, MonitorType newM, MonitorType oldM) {
        Music ms;
        MusicPlayList pls;
        MusicPlayList pls2;
        boolean keepFlg4;
        CompoundTag tag = this.getPlayerData(player);
        boolean keepFlg = oldM == MonitorType.ADD_MUSIC && newM == MonitorType.SEARCH_MUSIC || oldM == MonitorType.SEARCH_MUSIC && newM == MonitorType.ADD_MUSIC;
        boolean keepFlg2 = oldM == MonitorType.ADD_MUSIC && newM == MonitorType.UPLOAD_MUSIC || oldM == MonitorType.UPLOAD_MUSIC && newM == MonitorType.ADD_MUSIC;
        boolean keepFlg3 = oldM != null && newM != null && oldM.isKeepPlayListData() && newM.isKeepPlayListData();
        boolean bl = keepFlg4 = oldM != null && newM != null && oldM.isKeepMusicData() && newM.isKeepMusicData();
        if (!(keepFlg || keepFlg2 || keepFlg3 || keepFlg4)) {
            tag.m_128473_("Image");
            tag.m_128473_("ImageURL");
            tag.m_128473_("CreateName");
            tag.m_128473_("Publishing");
            tag.m_128473_("InitialAuthority");
            tag.m_128473_("InvitePlayerName");
            tag.m_128473_("InvitePlayers");
            tag.m_128473_("MusicLoaderType");
            tag.m_128473_("MusicSourceName");
            tag.m_128473_("MusicSource");
            tag.m_128473_("MusicAuthor");
            tag.m_128473_("ImportIdentifier");
            tag.m_128473_("ImportPlayListName");
            tag.m_128473_("ImportPlayListAuthor");
            tag.m_128473_("ImportPlayListMusicCount");
        }
        tag.m_128473_("SelectedPlayer");
        tag.m_128473_("MusicSearchName");
        MusicManager mm = MusicManager.getInstance();
        UUID pl = this.getSelectedPlayList(player);
        if (oldM == MonitorType.DETAIL_PLAY_LIST && newM == MonitorType.EDIT_PLAY_LIST && pl != null && (pls2 = mm.getSaveData().getPlayLists().get(pl)) != null) {
            this.setImage(player, pls2.getImage());
            this.setCreateName(player, pls2.getName());
            this.setInitialAuthority(player, pls2.getAuthority().getInitialAuthority() == AuthorityInfo.AuthorityType.MEMBER ? "member" : "read_only");
            this.setPublishing(player, pls2.getAuthority().isPublic() ? "public" : "private");
            this.setInvitePlayers(player, pls2.getAuthority().getRawAuthority().entrySet().stream().filter(n -> ((AuthorityInfo.AuthorityType)((Object)((Object)n.getValue()))).isInvitation()).map(Map.Entry::getKey).toList());
        }
        UUID m = this.getSelectedMusic(player);
        if (oldM == MonitorType.DETAIL_MUSIC && newM == MonitorType.EDIT_MUSIC && m != null && (pls = mm.getSaveData().getPlayLists().get(pl)) != null && pls.getMusicList().contains(m) && (ms = mm.getSaveData().getMusics().get(m)) != null) {
            this.setImage(player, ms.getImage());
            this.setCreateName(player, ms.getName());
            this.setMusicAuthor(player, ms.getAuthor());
            this.setMusicSource(player, ms.getSource());
            this.setMusicLoaderType(player, ms.getSource().getLoaderType());
        }
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        OENbtUtil.readMap((CompoundTag)tag, (String)"PlayerData", this.playerData);
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        OENbtUtil.writeMap((CompoundTag)tag, (String)"PlayerData", this.playerData);
        return super.m_6945_(tag);
    }

    public CompoundTag getSyncData(ServerPlayer player, CompoundTag tag) {
        CompoundTag pltag = this.playerData.get(player.m_36316_().getId());
        if (pltag != null) {
            tag.m_128365_("Data", (Tag)pltag);
        }
        return tag;
    }

    public void onSync(CompoundTag tag) {
        super.onSync(tag);
        this.myData = tag.m_128469_("Data");
    }

    @Nullable
    public UUID getSelectedMusic(@NotNull ServerPlayer player) {
        CompoundTag tag = this.getPlayerData(player);
        if (tag.m_128441_("SelectedMusic")) {
            return tag.m_128342_("SelectedMusic");
        }
        return null;
    }

    @Nullable
    public UUID getSelectedPlayer(@NotNull ServerPlayer player) {
        CompoundTag tag = this.getPlayerData(player);
        if (tag.m_128441_("SelectedPlayer")) {
            return tag.m_128342_("SelectedPlayer");
        }
        return null;
    }

    @Nullable
    public UUID getSelectedPlayList(@NotNull ServerPlayer player) {
        CompoundTag tag = this.getPlayerData(player);
        if (tag.m_128441_("SelectedPlayList")) {
            return tag.m_128342_("SelectedPlayList");
        }
        return null;
    }

    public CompoundTag getPlayerData(ServerPlayer player) {
        UUID id = player.m_36316_().getId();
        if (!this.playerData.containsKey(id)) {
            this.playerData.put(id, new CompoundTag());
        }
        return this.playerData.get(id);
    }

    @Nullable
    public UUID getMySelectedPlayer() {
        if (!this.myData.m_128441_("SelectedPlayer")) {
            return null;
        }
        return this.myData.m_128342_("SelectedPlayer");
    }

    @Nullable
    public UUID getMySelectedMusic() {
        if (!this.myData.m_128441_("SelectedMusic")) {
            return null;
        }
        return this.myData.m_128342_("SelectedMusic");
    }

    public UUID getMySelectedPlayList() {
        if (!this.myData.m_128441_("SelectedPlayList")) {
            return null;
        }
        return this.myData.m_128342_("SelectedPlayList");
    }

    public MusicSource getMyMusicSource() {
        if (this.myData.m_128441_("MusicSource")) {
            return (MusicSource)OENbtUtil.readSerializable((CompoundTag)this.myData, (String)"MusicSource", (ITAGSerializable)new MusicSource());
        }
        return MusicSource.EMPTY;
    }

    public void setMusicSource(ServerPlayer player, MusicSource source) {
        OENbtUtil.writeSerializable((CompoundTag)this.getPlayerData(player), (String)"MusicSource", (ITAGSerializable)source);
        this.m_6596_();
    }

    public int getMyImportPlayListMusicCount() {
        return this.myData.m_128451_("ImportPlayListMusicCount");
    }

    public void setImportPlayListMusicCount(@NotNull ServerPlayer player, int num) {
        this.getPlayerData(player).m_128405_("ImportPlayListMusicCount", num);
        this.m_6596_();
    }

    @NotNull
    public String getMyImportPlayListAuthor() {
        return this.myData.m_128461_("ImportPlayListAuthor");
    }

    public void setImportPlayListAuthor(@NotNull ServerPlayer player, @NotNull String name) {
        this.getPlayerData(player).m_128359_("ImportPlayListAuthor", name);
        this.m_6596_();
    }

    @NotNull
    public String getMyImportPlayListName() {
        return this.myData.m_128461_("ImportPlayListName");
    }

    public void setImportPlayListName(@NotNull ServerPlayer player, @NotNull String name) {
        this.getPlayerData(player).m_128359_("ImportPlayListName", name);
        this.m_6596_();
    }

    @NotNull
    public String getMyImportIdentifier() {
        return this.myData.m_128461_("ImportIdentifier");
    }

    public void setImportIdentifier(@NotNull ServerPlayer player, @NotNull String identifier) {
        this.getPlayerData(player).m_128359_("ImportIdentifier", identifier);
        this.m_6596_();
    }

    public String getMyMusicSourceName() {
        return this.myData.m_128461_("MusicSourceName");
    }

    public void setMusicSourceName(ServerPlayer player, String name) {
        this.getPlayerData(player).m_128359_("MusicSourceName", name);
        this.m_6596_();
    }

    public String getMyMusicAuthor() {
        return this.myData.m_128461_("MusicAuthor");
    }

    public void setMusicAuthor(ServerPlayer player, String name) {
        this.getPlayerData(player).m_128359_("MusicAuthor", name);
        this.m_6596_();
    }

    public String getMyMusicSearchName() {
        return this.myData.m_128461_("MusicSearchName");
    }

    public void setMusicSearchName(ServerPlayer player, String name) {
        this.getPlayerData(player).m_128359_("MusicSearchName", name);
        this.m_6596_();
    }

    public String getMyMusicLoaderType() {
        return this.myData.m_128461_("MusicLoaderType");
    }

    public void setMusicLoaderType(ServerPlayer player, String name) {
        this.getPlayerData(player).m_128359_("MusicLoaderType", name);
        this.m_6596_();
    }

    public void setSelectedPlayer(@NotNull ServerPlayer player, @Nullable UUID selectedPlayer) {
        if (selectedPlayer != null) {
            this.getPlayerData(player).m_128362_("SelectedPlayer", selectedPlayer);
        } else {
            this.getPlayerData(player).m_128473_("SelectedPlayer");
        }
        this.m_6596_();
    }

    public void setSelectedMusic(@NotNull ServerPlayer player, @Nullable UUID selectedMusic) {
        MonitorType type = this.getMonitor(player);
        if (type != null && type.isNeedSelectMusic() && this.getPlayerData(player).m_128441_("SelectedMusic")) {
            UUID old = this.getPlayerData(player).m_128342_("SelectedMusic");
            if (selectedMusic == null || !selectedMusic.equals(old)) {
                this.setMonitor(player, MonitorType.PLAY_LIST);
            }
        }
        if (selectedMusic != null) {
            this.getPlayerData(player).m_128362_("SelectedMusic", selectedMusic);
        } else {
            this.getPlayerData(player).m_128473_("SelectedMusic");
        }
        this.m_6596_();
    }

    public void setSelectedPlayList(@NotNull ServerPlayer player, @Nullable UUID selectedPlayList) {
        MonitorType type = this.getMonitor(player);
        if (type != null && type.isNeedSelectPlayList() && this.getPlayerData(player).m_128441_("SelectedPlayList")) {
            UUID old = this.getPlayerData(player).m_128342_("SelectedPlayList");
            if (selectedPlayList == null || !selectedPlayList.equals(old)) {
                this.setMonitor(player, MonitorType.PLAY_LIST);
            }
        }
        if (selectedPlayList != null) {
            this.getPlayerData(player).m_128362_("SelectedPlayList", selectedPlayList);
        } else {
            this.getPlayerData(player).m_128473_("SelectedPlayList");
        }
        this.m_6596_();
    }

    public List<UUID> getMyInvitePlayers() {
        ArrayList<UUID> pls = new ArrayList<UUID>();
        OENbtUtil.readUUIDList((CompoundTag)this.myData, (String)"InvitePlayers", pls);
        return pls;
    }

    public void setInvitePlayers(ServerPlayer player, List<UUID> players) {
        CompoundTag tag = this.getPlayerData(player);
        tag.m_128473_("InvitePlayers");
        OENbtUtil.writeUUIDList((CompoundTag)tag, (String)"InvitePlayers", players);
        this.m_6596_();
    }

    public String getMyInvitePlayerName() {
        return this.myData.m_128461_("InvitePlayerName");
    }

    public void setInvitePlayerName(ServerPlayer player, String name) {
        this.getPlayerData(player).m_128359_("InvitePlayerName", name);
        this.m_6596_();
    }

    public void setImage(ServerPlayer player, ImageInfo image) {
        OENbtUtil.writeSerializable((CompoundTag)this.getPlayerData(player), (String)"Image", (ITAGSerializable)image);
        this.m_6596_();
    }

    public ImageInfo getMyImage() {
        if (this.myData.m_128469_("Image").m_128456_()) {
            return ImageInfo.EMPTY;
        }
        return (ImageInfo)OENbtUtil.readSerializable((CompoundTag)this.myData, (String)"Image", (ITAGSerializable)new ImageInfo());
    }

    public String getMyInitialAuthority() {
        return this.myData.m_128461_("InitialAuthority");
    }

    public void setInitialAuthority(ServerPlayer player, String initialAuthority) {
        this.getPlayerData(player).m_128359_("InitialAuthority", initialAuthority);
        this.m_6596_();
    }

    public String getMyPublishing() {
        return this.myData.m_128461_("Publishing");
    }

    public void setPublishing(ServerPlayer player, String publishing) {
        this.getPlayerData(player).m_128359_("Publishing", publishing);
        this.m_6596_();
    }

    public String getMyCreateName() {
        return this.myData.m_128461_("CreateName");
    }

    public void setCreateName(ServerPlayer player, String name) {
        this.getPlayerData(player).m_128359_("CreateName", name);
        this.m_6596_();
    }

    public void setImageURL(ServerPlayer player, String url) {
        this.getPlayerData(player).m_128359_("ImageURL", url);
        this.m_6596_();
    }

    public String getMyImageURL() {
        return this.myData.m_128461_("ImageURL");
    }

    public MonitorType getMonitor(ServerPlayer player) {
        return MonitorType.getByNameOrDefault(this.getPlayerData(player).m_128461_("Monitor"), this, player.m_36316_().getId());
    }

    public void setMonitor(ServerPlayer player, MonitorType type) {
        MonitorType oldM = MonitorType.getByNameOrDefault(this.getPlayerData(player).m_128461_("Monitor"), this, player.m_36316_().getId());
        if (oldM != type) {
            this.updateMonitor(player, type, oldM);
        }
        this.getPlayerData(player).m_128359_("Monitor", type.getName());
        this.m_6596_();
    }

    public MonitorType getMyMonitor(Player player) {
        String name = this.myData.m_128461_("Monitor");
        return MonitorType.getByNameOrDefault(name, this, player.m_36316_().getId());
    }

    @Override
    public CompoundTag onInstruction(ServerPlayer player, String name, int num, CompoundTag data) {
        if ("set_monitor".equals(name)) {
            String mn = data.m_128461_("type");
            if (!mn.isEmpty()) {
                this.setMonitor(player, MonitorType.getByName(mn));
            }
            return null;
        }
        if ("add_playlist".equals(name)) {
            if (data.m_128441_("playlist")) {
                UUID pl = data.m_128342_("playlist");
                MusicManager.getInstance().addPlayListToPlayer(pl, player);
            }
            return data;
        }
        if ("set_image_url".equals(name)) {
            String url = data.m_128461_("url");
            this.setImageURL(player, url);
            return null;
        }
        if ("set_image".equals(name)) {
            ImageInfo image = (ImageInfo)OENbtUtil.readSerializable((CompoundTag)data, (String)"image", (ITAGSerializable)new ImageInfo());
            this.setImage(player, image);
            return null;
        }
        if ("set_create_name".equals(name)) {
            String cname = data.m_128461_("name");
            this.setCreateName(player, cname);
            return null;
        }
        if ("set_publishing".equals(name)) {
            String pub = data.m_128461_("publishing");
            this.setPublishing(player, pub);
            return null;
        }
        if ("set_initial_authority".equals(name)) {
            String ina = data.m_128461_("initial_authority");
            this.setInitialAuthority(player, ina);
            return null;
        }
        if ("set_invite_player_name".equals(name)) {
            String pname = data.m_128461_("name");
            this.setInvitePlayerName(player, pname);
            return null;
        }
        if ("set_invite_players".equals(name)) {
            ArrayList<UUID> pls = new ArrayList<UUID>();
            OENbtUtil.readUUIDList((CompoundTag)data, (String)"players", pls);
            this.setInvitePlayers(player, pls);
            return null;
        }
        if ("set_selected_playlist".equals(name)) {
            if (data.m_128441_("playlist")) {
                UUID id = data.m_128342_("playlist");
                this.setSelectedPlayList(player, id);
            } else {
                this.setSelectedPlayList(player, null);
            }
            return data;
        }
        if ("set_music_loader_type".equals(name)) {
            String lname = data.m_128461_("name");
            this.setMusicLoaderType(player, lname);
            return null;
        }
        if ("set_music_source_name".equals(name)) {
            String mname = data.m_128461_("name");
            this.setMusicSourceName(player, mname);
            return null;
        }
        if ("set_music_source".equals(name)) {
            MusicSource ms = (MusicSource)OENbtUtil.readSerializable((CompoundTag)data, (String)"MusicSource", (ITAGSerializable)new MusicSource());
            this.setMusicSource(player, ms);
            return null;
        }
        if ("set_music_search_name".equals(name)) {
            String sname = data.m_128461_("name");
            this.setMusicSearchName(player, sname);
            return null;
        }
        if ("set_music_author".equals(name)) {
            String author = data.m_128461_("author");
            this.setMusicAuthor(player, author);
            return null;
        }
        if ("set_import_identifier".equals(name)) {
            this.setImportIdentifier(player, data.m_128461_("id"));
            return null;
        }
        if ("set_import_playlist_name".equals(name)) {
            this.setImportPlayListName(player, data.m_128461_("name"));
            return null;
        }
        if ("set_import_playlist_author".equals(name)) {
            this.setImportPlayListAuthor(player, data.m_128461_("author"));
            return null;
        }
        if ("set_import_playlist_music_count".equals(name)) {
            this.setImportPlayListMusicCount(player, data.m_128451_("count"));
            return null;
        }
        if ("set_selected_music".equals(name)) {
            if (data.m_128441_("music")) {
                UUID id = data.m_128342_("music");
                this.setSelectedMusic(player, id);
            } else {
                this.setSelectedMusic(player, null);
            }
            return null;
        }
        if ("set_selected_player".equals(name)) {
            if (data.m_128441_("player")) {
                UUID id = data.m_128342_("player");
                this.setSelectedPlayer(player, id);
            } else {
                this.setSelectedPlayer(player, null);
            }
            return null;
        }
        return super.onInstruction(player, name, num, data);
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public static enum MonitorType {
        OFF("off", false),
        TEST("test", false),
        PLAY_LIST("play_list", false),
        ADD_PLAY_LIST("add_play_list", false),
        ADD_ONLINE_PLAY_LIST("add_online_play_list", false),
        EDIT_PLAY_LIST("edit_play_list", true),
        DETAIL_PLAY_LIST("detail_play_list", true),
        IMPORT_PLAY_LIST_SELECT("import_play_list_select", false),
        CREATE_PLAY_LIST("create_play_list", false),
        DELETE_PLAY_LIST("delete_play_list", true),
        ADD_MUSIC("add_music", true),
        SEARCH_MUSIC("search_music", true),
        UPLOAD_MUSIC("upload_music", true),
        DETAIL_MUSIC("detail_music", true),
        EDIT_MUSIC("edit_music", true),
        DELETE_MUSIC("delete_music", true),
        IMPORT_YOUTUBE_PLAY_LIST("import_youtube_play_list", false),
        IMPORT_MUSICS_SELECT("import_musics_select", true),
        IMPORT_YOUTUBE_PLAY_LIST_MUSICS("import_youtube_play_list_musics", true),
        AUTHORITY("authority", true);

        private final String name;
        private final boolean needSelectPlayList;

        private MonitorType(String name, boolean needSelectPlayList) {
            this.name = name;
            this.needSelectPlayList = needSelectPlayList;
        }

        public String getName() {
            return this.name;
        }

        public static MonitorType getByNameOrDefault(String name, MusicManagerBlockEntity blockEntity, UUID player) {
            for (MonitorType value : MonitorType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return MonitorType.getDefault(blockEntity, player);
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : MonitorType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return OFF;
        }

        public boolean isNeedSelectPlayList() {
            return this.needSelectPlayList;
        }

        public boolean isNeedSelectMusic() {
            return this == DETAIL_MUSIC || this == DELETE_MUSIC || this == EDIT_MUSIC;
        }

        public boolean isKeepPlayListData() {
            return this == CREATE_PLAY_LIST || this == IMPORT_PLAY_LIST_SELECT || this == IMPORT_YOUTUBE_PLAY_LIST;
        }

        public boolean isKeepMusicData() {
            return this == ADD_MUSIC || this == IMPORT_MUSICS_SELECT || this == IMPORT_YOUTUBE_PLAY_LIST_MUSICS;
        }

        public static MonitorType getDefault(MusicManagerBlockEntity blockEntity, UUID player) {
            return blockEntity.isPower() ? PLAY_LIST : OFF;
        }
    }
}

