/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.music.subtitle.SubtitleEntry;
import dev.felnull.imp.client.music.subtitle.SubtitleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class MusicSubtitleOverlay
extends Overlay {
    public static final MusicSubtitleOverlay SUBTITLE_OVERLAY = new MusicSubtitleOverlay();
    private static final Minecraft mc = Minecraft.m_91087_();
    private final Map<SubtitleEntry, Long> SUBTITLES = new HashMap<SubtitleEntry, Long>();
    private final List<SubtitleEntry> REMOVE_SUBTITLES = new ArrayList<SubtitleEntry>();
    private final Map<SubtitleEntry, Long> UPDATE_SUBTITLES = new HashMap<SubtitleEntry, Long>();
    private final Map<SubtitleEntry, Boolean> PAUSED_SUBTITLES = new HashMap<SubtitleEntry, Boolean>();
    private final Map<SubtitleEntry, Long> PAUSED_TIME_SUBTITLES = new HashMap<SubtitleEntry, Long>();

    public void addSubtitle(SubtitleEntry entry) {
        this.SUBTITLES.put(entry, System.currentTimeMillis());
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        if (IamMusicPlayer.CONFIG.subtitleType != SubtitleType.OVERLAY) {
            this.SUBTITLES.clear();
            this.REMOVE_SUBTITLES.clear();
            this.UPDATE_SUBTITLES.clear();
            this.PAUSED_SUBTITLES.clear();
            this.PAUSED_TIME_SUBTITLES.clear();
            return;
        }
        this.SUBTITLES.forEach((n, m) -> {
            Boolean pc = this.PAUSED_SUBTITLES.get(n);
            boolean cp = n.musicPlayer().isPaused();
            if (pc != null && pc != cp) {
                if (cp) {
                    this.PAUSED_TIME_SUBTITLES.put((SubtitleEntry)n, System.currentTimeMillis());
                } else {
                    Long pt = this.PAUSED_TIME_SUBTITLES.get(n);
                    if (pt != null) {
                        this.UPDATE_SUBTITLES.put((SubtitleEntry)n, m + (System.currentTimeMillis() - pt));
                    }
                    this.PAUSED_TIME_SUBTITLES.clear();
                }
            }
            this.PAUSED_SUBTITLES.put((SubtitleEntry)n, cp);
            if (m + n.duration() < System.currentTimeMillis() && n.musicPlayer().isPlaying() || n.musicPlayer().isFinished() || !n.musicPlayer().isPaused() && !n.musicPlayer().isPlaying()) {
                this.REMOVE_SUBTITLES.add((SubtitleEntry)n);
            }
        });
        this.SUBTITLES.putAll(this.UPDATE_SUBTITLES);
        this.UPDATE_SUBTITLES.clear();
        this.REMOVE_SUBTITLES.forEach(this.SUBTITLES::remove);
        this.REMOVE_SUBTITLES.clear();
        if (this.SUBTITLES.isEmpty()) {
            return;
        }
        Objects.requireNonNull(MusicSubtitleOverlay.mc.f_91062_);
        int fh = 9;
        int mh = mc.m_91268_().m_85446_() - this.getMinHeight() - 1;
        mh -= this.SUBTITLES.size() * (fh + 1);
        int ch = 0;
        for (SubtitleEntry sub : this.SUBTITLES.keySet()) {
            this.drawText(poseStack, mh + ch, sub.component());
            ch += fh + 1;
        }
    }

    private void drawText(PoseStack poseStack, int y, Component text) {
        int x = mc.m_91268_().m_85445_() / 2;
        Font font = MusicSubtitleOverlay.mc.f_91062_;
        int width = font.m_92852_((FormattedText)text) + 2;
        Objects.requireNonNull(font);
        MusicSubtitleOverlay.m_93172_((PoseStack)poseStack, (int)(x -= width / 2), (int)y, (int)(x + width), (int)(y + 9), (int)MusicSubtitleOverlay.mc.f_91066_.m_92170_(0.8f));
        font.m_92889_(poseStack, text, (float)(x + 1), (float)(y + 1), 0xE0E0E0);
    }

    private int getMinHeight() {
        int h = 0;
        if (MusicSubtitleOverlay.mc.f_91080_ == null) {
            h += 22;
            if (MusicSubtitleOverlay.mc.f_91074_ != null && !MusicSubtitleOverlay.mc.f_91074_.m_5833_() && !MusicSubtitleOverlay.mc.f_91074_.m_7500_()) {
                h += 17;
                if (MusicSubtitleOverlay.mc.f_91074_.m_21230_() > 0) {
                    h += 10;
                }
            }
        } else if (MusicSubtitleOverlay.mc.f_91080_ instanceof ChatScreen) {
            h += 15;
        }
        return h;
    }
}

