/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class SortButton
extends Button
implements IIMPSmartRender {
    protected final boolean longed;

    private SortButton(int x, int y, int w, int tx, Component component, Button.OnPress onPress, boolean longed, Screen screen) {
        super(x, y, w, 9, component, onPress, longed ? f_93716_ : (button, poseStack, px, py) -> screen.m_96602_(poseStack, SortButton.getText(button), px, py));
        this.longed = longed;
    }

    private static Component getText(Button button) {
        Button button2 = button;
        if (button2 instanceof SortTypeButton) {
            SortTypeButton sortButton = (SortTypeButton)button2;
            return new TranslatableComponent("imp.sortType." + sortButton.getSortType().getName());
        }
        button2 = button;
        if (button2 instanceof OrderTypeButton) {
            OrderTypeButton orderButton = (OrderTypeButton)button2;
            return new TranslatableComponent("imp.orderType." + orderButton.getOrderType().getName());
        }
        return new TextComponent("none");
    }

    public void m_5691_() {
        this.cycle();
        super.m_5691_();
    }

    public void m_6303_(PoseStack poseStack, int mx, int my, float f) {
        this.drawSmartButtonBox(poseStack, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, this.m_5702_());
        if (this.m_5702_()) {
            this.m_7428_(poseStack, mx, my);
        }
    }

    public abstract void cycle();

    public static class SortTypeButton
    extends SortButton {
        private SortType type = SortType.NAME;

        public SortTypeButton(int x, int y, Button.OnPress onPress, boolean longed, Screen screen) {
            super(x, y, longed ? 97 : 9, longed ? 61 : 52, (Component)new TranslatableComponent("imp.button.sort"), onPress, longed, screen);
        }

        @Override
        public void cycle() {
            this.type = SortType.values()[(this.type.ordinal() + 1) % SortType.values().length];
        }

        public SortType getSortType() {
            return this.type;
        }

        public <T extends IIMPComparable> List<T> sort(List<T> target, OrderTypeButton orderTypeButton) {
            return target.stream().sorted(this.getSortType().getComparator(orderTypeButton.getOrderType())).toList();
        }

        @Override
        public void m_6303_(PoseStack poseStack, int mx, int my, float f) {
            super.m_6303_(poseStack, mx, my, f);
            OERenderUtil.drawTexture((ResourceLocation)MusicManagerMonitor.WIDGETS_TEXTURE, (PoseStack)poseStack, (float)(this.f_93620_ + 1), (float)(this.f_93621_ + 1), (float)(73 + this.getSortType().ordinal() * 7), (float)0.0f, (float)7.0f, (float)7.0f);
            if (this.longed) {
                this.drawSmartText(poseStack, SortButton.getText(this), this.f_93620_ + 9, this.f_93621_ + 1);
            }
        }
    }

    public static enum SortType {
        NAME("name", (o1, o2) -> o1.getCompareName().compareTo(o2.getCompareName())),
        PLAYER("player", (o1, o2) -> o1.getComparePlayerName().compareTo(o2.getComparePlayerName())),
        CREATE_DATE("create_date", (o1, o2) -> (int)(o1.getCompareDate() - o2.getCompareDate()));

        private final String name;
        private final Comparator<IIMPComparable> comparator;
        private final Comparator<IIMPComparable> rcomparator;

        private SortType(String name, Comparator<IIMPComparable> comparator) {
            this.name = name;
            this.comparator = comparator;
            this.rcomparator = comparator.reversed();
        }

        public String getName() {
            return this.name;
        }

        public Comparator<IIMPComparable> getComparator(OrderType orderType) {
            return orderType.isReverse() ? this.rcomparator : this.comparator;
        }
    }

    public static class OrderTypeButton
    extends SortButton {
        private OrderType type = OrderType.DESCENDING;

        public OrderTypeButton(int x, int y, Button.OnPress onPress, boolean longed, Screen screen) {
            super(x, y, longed ? 88 : 9, longed ? 158 : 52, (Component)new TranslatableComponent("imp.button.order"), onPress, longed, screen);
        }

        @Override
        public void cycle() {
            this.type = OrderType.values()[(this.type.ordinal() + 1) % OrderType.values().length];
        }

        public OrderType getOrderType() {
            return this.type;
        }

        @Override
        public void m_6303_(PoseStack poseStack, int mx, int my, float f) {
            super.m_6303_(poseStack, mx, my, f);
            OERenderUtil.drawTexture((ResourceLocation)MusicManagerMonitor.WIDGETS_TEXTURE, (PoseStack)poseStack, (float)(this.f_93620_ + 1), (float)(this.f_93621_ + 1), (float)(73 + this.getOrderType().ordinal() * 7), (float)7.0f, (float)7.0f, (float)7.0f);
            if (this.longed) {
                this.drawSmartText(poseStack, SortButton.getText(this), this.f_93620_ + 9, this.f_93621_ + 1);
            }
        }
    }

    public static enum OrderType {
        ASCENDING("ascending", false),
        DESCENDING("descending", true);

        private final String name;
        private final boolean reverse;

        private OrderType(String name, boolean reverse) {
            this.name = name;
            this.reverse = reverse;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public String getName() {
            return this.name;
        }
    }
}

