/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.client.gui.components.BoomboxButton;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.inventory.BoomboxMenu;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.client.gui.screen.OEItemBEContainerBaseScreen;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.inventory.OEItemBEBaseMenu;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoomboxScreen
extends OEItemBEContainerBaseScreen<BoomboxMenu> {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/boombox/boombox_base.png");
    public static final ResourceLocation EMPTY_CASSETTE_TAPE_SLOT = new ResourceLocation("iammusicplayer", "textures/gui/container/slot/cassette_tape_slot.png");
    public static final ResourceLocation EMPTY_ANTENNA_SLOT = new ResourceLocation("iammusicplayer", "textures/gui/container/slot/antenna_slot.png");
    private final Map<BoomboxData.MonitorType, BoomboxMonitor> monitors = new HashMap<BoomboxData.MonitorType, BoomboxMonitor>();
    protected BoomboxMonitor monitor;
    public long lastNoAntenna;

    public BoomboxScreen(BoomboxMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((OEItemBEBaseMenu)abstractContainerMenu, inventory, component);
        this.f_97726_ = 214;
        this.f_97727_ = 175;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5, this.f_97736_ + 17, BoomboxData.ButtonType.POWER, n -> this.insPressButton(BoomboxData.ButtonType.POWER), this::getButtons, this::isPower));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 19, this.f_97736_ + 17, BoomboxData.ButtonType.RADIO, n -> {
            if (!this.getAntenna().m_41619_() && IMPItemUtil.isAntenna(this.getAntenna())) {
                this.insPressButton(BoomboxData.ButtonType.RADIO);
            } else {
                this.lastNoAntenna = System.currentTimeMillis();
            }
        }, this::getButtons));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 38, this.f_97736_ + 17, BoomboxData.ButtonType.START, n -> this.insPressButton(BoomboxData.ButtonType.START), this::getButtons));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 57, this.f_97736_ + 17, BoomboxData.ButtonType.PAUSE, n -> this.insPressButton(BoomboxData.ButtonType.PAUSE), this::getButtons));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 76, this.f_97736_ + 17, BoomboxData.ButtonType.STOP, n -> this.insPressButton(BoomboxData.ButtonType.STOP), this::getButtons));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 95, this.f_97736_ + 17, BoomboxData.ButtonType.LOOP, n -> this.insPressButton(BoomboxData.ButtonType.LOOP), this::getButtons));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 114 + 14, this.f_97736_ + 17, BoomboxData.ButtonType.VOL_DOWN, n -> this.insPressButton(BoomboxData.ButtonType.VOL_DOWN), this::getButtons));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 133 + 14, this.f_97736_ + 17, BoomboxData.ButtonType.VOL_UP, n -> this.insPressButton(BoomboxData.ButtonType.VOL_UP), this::getButtons));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 152 + 14, this.f_97736_ + 17, BoomboxData.ButtonType.VOL_MUTE, n -> this.insPressButton(BoomboxData.ButtonType.VOL_MUTE), this::getButtons));
        this.m_142416_((GuiEventListener)new BoomboxButton(this.f_97735_ + 5 + 171 + 14, this.f_97736_ + 17, BoomboxData.ButtonType.VOL_MAX, n -> this.insPressButton(BoomboxData.ButtonType.VOL_MAX), this::getButtons));
        this.changeScreenMonitor(this.getRawMonitorType());
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        super.m_6305_(poseStack, i, j, f);
    }

    protected void m_7286_(PoseStack poseStack, float f, int i, int j) {
        super.m_7286_(poseStack, f, i, j);
        if (this.getCassetteTape().m_41619_()) {
            OERenderUtil.drawTexture((ResourceLocation)EMPTY_CASSETTE_TAPE_SLOT, (PoseStack)poseStack, (float)(this.f_97735_ + 183), (float)(this.f_97736_ + 98), (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)16.0f, (float)16.0f);
        }
        if (this.getAntenna().m_41619_()) {
            OERenderUtil.drawTexture((ResourceLocation)EMPTY_ANTENNA_SLOT, (PoseStack)poseStack, (float)(this.f_97735_ + 183), (float)(this.f_97736_ + 124), (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)16.0f, (float)16.0f);
        }
        if (this.monitor != null) {
            this.monitor.render(poseStack, f, i, j);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.monitor != null) {
            if (this.getRawMonitorType() != this.monitor.getType()) {
                this.changeScreenMonitor(this.getRawMonitorType());
            }
            this.monitor.tick();
        }
    }

    public void insSelectedPlayList(@Nullable UUID uuid) {
        CompoundTag tag = new CompoundTag();
        if (uuid != null) {
            tag.m_128362_("pl", uuid);
        }
        this.instruction("set_selected_play_list", 0, tag);
    }

    public void insRadioUrl(String url) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("url", url);
        this.instruction("set_radio_url", 0, tag);
    }

    public void insSelectedMusic(@Nullable UUID musicId) {
        CompoundTag tag = new CompoundTag();
        if (musicId != null) {
            tag.m_128362_("m", musicId);
        }
        this.instruction("set_selected_music", 0, tag);
    }

    public boolean isMute() {
        return this.getBoomBoxData().isMute();
    }

    public boolean isPlaying() {
        return this.getBoomBoxData().isPlaying();
    }

    public int getVolume() {
        return this.getBoomBoxData().getVolume();
    }

    public long getMusicPosition() {
        return this.getBoomBoxData().getMusicPosition();
    }

    private boolean isPower() {
        return this.getBoomBoxData().isPower();
    }

    public boolean isLoop() {
        return this.getBoomBoxData().isLoop();
    }

    public BoomboxData getBoomBoxData() {
        BlockEntity blockEntity;
        if (this.isBlock() && (blockEntity = this.getBlockEntity()) instanceof BoomboxBlockEntity) {
            BoomboxBlockEntity boomboxBlockEntity = (BoomboxBlockEntity)blockEntity;
            return boomboxBlockEntity.getBoomboxData();
        }
        return BoomboxItem.getData(this.getItem());
    }

    public void insMonitor(BoomboxData.MonitorType monitorType) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", monitorType.getName());
        this.instruction("set_monitor", 0, tag);
    }

    public boolean isMusicLoading() {
        return this.getBoomBoxData().isLoadingMusic();
    }

    public ItemStack getCassetteTape() {
        return (ItemStack)((BoomboxMenu)this.m_6262_()).m_38927_().get(0);
    }

    public ItemStack getAntenna() {
        return (ItemStack)((BoomboxMenu)this.m_6262_()).m_38927_().get(1);
    }

    public void insVolume(int volume) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("volume", volume);
        this.instruction("set_volume", 0, tag);
    }

    public void insPositionAndRestart(long position) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("position", position);
        this.instruction("restat_and_set_position", 0, tag);
    }

    public void insContinuousType(@NotNull BoomboxData.ContinuousType continuousType) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", continuousType.getName());
        this.instruction("set_continuous_type", 0, tag);
    }

    public void insLoop(boolean loop) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("loop", loop);
        this.instruction("set_loop", 0, tag);
    }

    public void insPause() {
        this.instruction("set_pause", 0, new CompoundTag());
    }

    public void insPlaying(boolean playing) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("playing", playing);
        this.instruction("set_playing", 0, tag);
    }

    public void insRadioSource(MusicSource source) {
        CompoundTag tag = new CompoundTag();
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"source", (ITAGSerializable)source);
        this.instruction("set_radio_source", 0, tag);
    }

    public void insRadioImage(ImageInfo imageInfo) {
        CompoundTag tag = new CompoundTag();
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"image", (ITAGSerializable)imageInfo);
        this.instruction("set_radio_image", 0, tag);
    }

    public void insRadioName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", name);
        this.instruction("set_radio_name", 0, tag);
    }

    public void insRadioAuthor(String author) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("author", author);
        this.instruction("set_radio_author", 0, tag);
    }

    protected ResourceLocation getBackGrandTexture() {
        return BG_TEXTURE;
    }

    private BoomboxData.Buttons getButtons() {
        return this.getBoomBoxData().getButtons();
    }

    private void insPressButton(BoomboxData.ButtonType type) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", type.getName());
        this.instruction("buttons_press", 0, tag);
    }

    private void changeScreenMonitor(BoomboxData.MonitorType type) {
        if (this.monitor != null) {
            this.monitor.renderables.forEach(n -> {
                Widget guiEventListener$temp = n;
                if (guiEventListener$temp instanceof GuiEventListener) {
                    GuiEventListener guiEventListener = (GuiEventListener)guiEventListener$temp;
                    this.m_169411_(guiEventListener);
                }
            });
            this.monitor.depose();
        }
        if (!this.monitors.containsKey((Object)type)) {
            this.monitors.put(type, BoomboxMonitor.createdBoomBoxMonitor(type, this));
        }
        this.monitor = this.monitors.get((Object)type);
        this.monitor.init(this.f_97735_, this.f_97736_);
        this.monitor.renderables.forEach(n -> {
            Widget widget$temp = n;
            if (widget$temp instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)widget$temp;
                this.m_142416_((GuiEventListener)widget);
            }
        });
    }

    private BoomboxData.MonitorType getRawMonitorType() {
        return this.getBoomBoxData().getMonitorType();
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.monitor != null) {
            this.monitor.depose();
        }
    }

    public void m_7400_(List<Path> list) {
        if (this.monitor != null) {
            this.monitor.onFilesDrop(list);
        }
    }
}

