/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.PlayListBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.SavedPlayListBaseMMMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditPlayListMMMonitor
extends SavedPlayListBaseMMMonitor {
    public EditPlayListMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public boolean done(ImageInfo imageInfo, String name) {
        PlayListBaseMMMonitor.PublishingType pubType = this.getPublishingType();
        PlayListBaseMMMonitor.InitialAuthorityType initAuthType = this.getInitialAuthorityType();
        List<UUID> invitePlayers = this.getInvitePlayers();
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            NetworkManager.sendToServer((ResourceLocation)IMPPackets.MUSIC_PLAYLIST_EDIT, (FriendlyByteBuf)new IMPPackets.MusicPlayListMessage(musicManagerBlock.getMySelectedPlayList(), name, imageInfo, pubType == PlayListBaseMMMonitor.PublishingType.PUBLIC, initAuthType == PlayListBaseMMMonitor.InitialAuthorityType.MEMBER, invitePlayers, BlockEntityExistence.getByBlockEntity((BlockEntity)this.getScreen().getBlockEntity()), new ArrayList<Music>()).toFBB());
        }
        return true;
    }

    @Override
    protected Collection<UUID> excludeInvitePlayers(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            return pl.getAuthority().getPlayersAuthority().keySet();
        }
        return null;
    }

    @Override
    protected @NotNull MusicManagerBlockEntity.MonitorType getDoneBackMonitor() {
        return MusicManagerBlockEntity.MonitorType.DETAIL_PLAY_LIST;
    }

    @Override
    @Nullable
    protected ImageNameBaseMMMonitor.DoneType getDoneType() {
        return ImageNameBaseMMMonitor.DoneType.SAVE;
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.DETAIL_PLAY_LIST;
    }

    protected MusicPlayList getSelectedMusicPlayList() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getSelectedMusicPlayList(musicManagerBlockEntity);
        }
        return null;
    }

    protected MusicPlayList getSelectedMusicPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<MusicPlayList> pls = this.getSyncManager().getMyPlayList();
        if (pls == null) {
            return null;
        }
        return pls.stream().filter(n -> n.getUuid().equals(this.getSelectedPlayList(musicManagerBlockEntity))).findFirst().orElse(null);
    }

    protected UUID getSelectedPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMySelectedPlayList();
    }
}

