/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.handler;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.felnull.imp.IMPConfig;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.client.gui.components.MusicVolumeSlider;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.MusicSyncManager;
import dev.felnull.imp.client.renderer.item.hand.BoomboxHandRenderer;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.otyacraftengine.client.event.ClientEvent;
import dev.felnull.otyacraftengine.client.event.FabricOBJLoaderEvent;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SoundOptionsScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ClientHandler {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void init() {
        FabricOBJLoaderEvent.LOAD.register(ClientHandler::objLoad);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(ClientHandler::onClientLevelLoad);
        ClientEvent.CHANGE_HAND_HEIGHT.register(ClientHandler::changeHandHeight);
        ClientGuiEvent.INIT_POST.register(ClientHandler::onScreenInit);
        AutoConfig.getConfigHolder(IMPConfig.class).registerSaveListener(ClientHandler::onConfigSave);
        ClientEvent.POSE_HUMANOID_ARM.register(ClientHandler::onPoseHumanoidArm);
    }

    private static InteractionResult onConfigSave(ConfigHolder<IMPConfig> configHolder, IMPConfig impConfig) {
        MusicEngine.getInstance().reload();
        return InteractionResult.SUCCESS;
    }

    private static EventResult objLoad(ResourceLocation resourceLocation) {
        if ("iammusicplayer".equals(resourceLocation.m_135827_())) {
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private static void onClientLevelLoad(ClientLevel clientLevel) {
        MusicSyncManager.getInstance().reset();
    }

    private static EventResult changeHandHeight(InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        if (oldStack.m_41720_() instanceof BoomboxItem && newStack.m_41720_() instanceof BoomboxItem && BoomboxItem.matches(oldStack, newStack)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void onScreenInit(Screen screen, ScreenAccess screenAccess) {
        if (screen instanceof SoundOptionsScreen) {
            int i = 11;
            int x = screen.f_96543_ / 2 - 155 + i % 2 * 160;
            int y = screen.f_96544_ / 6 - 12 + 24 * (i >> 1);
            screenAccess.addRenderableWidget((AbstractWidget)new MusicVolumeSlider(x, y, 150));
            screenAccess.addRenderableWidget((AbstractWidget)new ImageButton(x + 150 + 4, y, 20, 20, 48, 105, 20, MusicManagerMonitor.WIDGETS_TEXTURE, 256, 256, n -> mc.m_91152_((Screen)AutoConfig.getConfigScreen(IMPConfig.class, (Screen)screen).get()), (Component)new TranslatableComponent("imp.button.config")));
        }
    }

    private static EventResult onPoseHumanoidArm(HumanoidArm arm, InteractionHand hand, HumanoidModel<? extends LivingEntity> model, LivingEntity livingEntity) {
        ItemStack item = livingEntity.m_21120_(hand);
        if (item.m_150930_(IMPBlocks.BOOMBOX.m_5456_()) && (float)BoomboxItem.getTransferProgress(item) >= 1.0f) {
            BoomboxHandRenderer.pose(arm, model, item);
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static void onWorldPause(boolean pause) {
        MusicRingManager rm = MusicRingManager.getInstance();
        MusicEngine mm = MusicEngine.getInstance();
        if (pause) {
            rm.pause();
            mm.pause();
        } else {
            rm.resume();
            mm.resume();
        }
    }
}

