/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.api.event.ClientMusicEvent;
import dev.felnull.imp.client.music.MusicLoadThread;
import dev.felnull.imp.client.music.player.IMusicPlayer;
import dev.felnull.imp.client.music.subtitle.IMusicSubtitle;
import dev.felnull.imp.client.music.subtitle.SubtitleEntry;
import dev.felnull.imp.client.music.tracker.IMPMusicTrackers;
import dev.felnull.imp.client.music.tracker.IMusicTracker;
import dev.felnull.imp.client.util.SoundMath;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.music.resource.MusicSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MusicEngine {
    private static final Logger LOGGER = LogManager.getLogger(MusicEngine.class);
    private static final MusicEngine INSTANCE = new MusicEngine();
    private final Map<UUID, MusicPlayEntry> MUSIC_PLAYERS = new HashMap<UUID, MusicPlayEntry>();
    private final Map<UUID, MusicLoadThread> MUSIC_LOADS = new HashMap<UUID, MusicLoadThread>();
    private final List<UUID> REMOVES_PLAYERS = new ArrayList<UUID>();
    private final List<UUID> REMOVE_LOADS = new ArrayList<UUID>();
    private final Map<UUID, Long> LAST_SUBTITLE = new HashMap<UUID, Long>();
    private final List<UnPauseStartEntry> UNPAUSES_STARTS = new ArrayList<UnPauseStartEntry>();
    private final Map<UUID, MusicReloadEntry> RESTART_LIVES = new HashMap<UUID, MusicReloadEntry>();
    private final List<UUID> RESTART_CHECK = new ArrayList<UUID>();
    private long lastTime;
    private long lastProsesTime;
    private boolean pause;
    private boolean reloading;
    public boolean reloadFlag;

    public static MusicEngine getInstance() {
        return INSTANCE;
    }

    public int getCurrentMusicPlayed() {
        return this.MUSIC_PLAYERS.size() + this.MUSIC_LOADS.size();
    }

    public int getMaxMusicPlayed() {
        return Math.max(IamMusicPlayer.CONFIG.maxPlayCont, 0);
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public String getDebugString() {
        return String.format("Musics: %d/%d %d ms", this.getCurrentMusicPlayed(), this.getMaxMusicPlayed(), this.lastProsesTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playMusicPlayer(UUID id, long delay) {
        Object object = this.UNPAUSES_STARTS;
        synchronized (object) {
            if (this.pause) {
                this.UNPAUSES_STARTS.add(new UnPauseStartEntry(id, delay));
                return true;
            }
        }
        object = this.MUSIC_PLAYERS;
        synchronized (object) {
            if (!this.MUSIC_PLAYERS.containsKey(id)) {
                return false;
            }
            IMusicPlayer player = this.MUSIC_PLAYERS.get(id).player();
            if (!player.isPlaying()) {
                player.play(delay);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAddMusicPlayer(UUID id, MusicPlaybackInfo playbackInfo, MusicSource source, long position, MusicLoadThread.MusicLoadResultListener listener) {
        Map<UUID, MusicLoadThread> map = this.MUSIC_LOADS;
        synchronized (map) {
            if (this.getCurrentMusicPlayed() >= this.getMaxMusicPlayed() || this.MUSIC_LOADS.containsKey(id) || this.MUSIC_PLAYERS.containsKey(id)) {
                return false;
            }
            MusicLoadThread mt = new MusicLoadThread(source, playbackInfo, position, (result, time, player, retry) -> {
                if (result) {
                    this.addMusicPlayer(id, playbackInfo, player);
                }
                listener.onResult(result, time, player, retry);
            });
            this.MUSIC_LOADS.put(id, mt);
            mt.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopLoadMusicPlayer(UUID id) {
        Map<UUID, MusicLoadThread> map = this.MUSIC_LOADS;
        synchronized (map) {
            MusicLoadThread load = this.MUSIC_LOADS.remove(id);
            if (load != null) {
                if (load.isAlive()) {
                    load.interrupt();
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMusicPlayer(UUID id, MusicPlaybackInfo playbackInfo, IMusicPlayer musicPlayer) {
        Map<UUID, MusicPlayEntry> map = this.MUSIC_PLAYERS;
        synchronized (map) {
            if (this.getCurrentMusicPlayed() >= this.getMaxMusicPlayed() && !this.MUSIC_LOADS.containsKey(id) || this.MUSIC_PLAYERS.containsKey(id)) {
                return false;
            }
            this.MUSIC_PLAYERS.put(id, new MusicPlayEntry(playbackInfo, musicPlayer));
            musicPlayer.setVolume(SoundMath.calculateVolume(playbackInfo.getVolume()));
            musicPlayer.setRange(playbackInfo.getRange());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMusicPlaybackInfo(UUID id, MusicPlaybackInfo playbackInfo) {
        Map<UUID, MusicPlayEntry> map = this.MUSIC_PLAYERS;
        synchronized (map) {
            if (!this.MUSIC_PLAYERS.containsKey(id)) {
                return false;
            }
            this.MUSIC_PLAYERS.put(id, new MusicPlayEntry(playbackInfo, this.MUSIC_PLAYERS.get(id).player()));
            IMusicPlayer player = this.MUSIC_PLAYERS.get(id).player();
            player.setVolume(SoundMath.calculateVolume(playbackInfo.getVolume()));
            player.setRange(playbackInfo.getRange());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopMusicPlayer(UUID id) {
        Map<UUID, MusicPlayEntry> map = this.RESTART_LIVES;
        synchronized (map) {
            if (this.RESTART_LIVES.containsKey(id)) {
                if (this.RESTART_CHECK.contains(id)) {
                    this.RESTART_LIVES.remove(id);
                    this.RESTART_CHECK.remove(id);
                    return true;
                }
                this.RESTART_CHECK.add(id);
            }
        }
        map = this.UNPAUSES_STARTS;
        synchronized (map) {
            UnPauseStartEntry uss = null;
            for (UnPauseStartEntry us : this.UNPAUSES_STARTS) {
                if (!us.id().equals(id)) continue;
                uss = us;
                break;
            }
            if (uss != null) {
                this.UNPAUSES_STARTS.remove(uss);
                return true;
            }
        }
        map = this.MUSIC_PLAYERS;
        synchronized (map) {
            MusicPlayEntry rmPly = this.MUSIC_PLAYERS.remove(id);
            this.LAST_SUBTITLE.remove(id);
            if (rmPly != null) {
                rmPly.player().stop();
                rmPly.player().destroy();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllMusicPlayer() {
        Map<UUID, MusicPlayEntry> map = this.MUSIC_PLAYERS;
        synchronized (map) {
            this.MUSIC_PLAYERS.forEach((n, m) -> this.REMOVES_PLAYERS.add((UUID)n));
            this.RESTART_LIVES.forEach((n, m) -> this.REMOVES_PLAYERS.add((UUID)n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllMusicLoad() {
        Map<UUID, MusicLoadThread> map = this.MUSIC_LOADS;
        synchronized (map) {
            this.MUSIC_LOADS.forEach((n, m) -> this.REMOVE_LOADS.add((UUID)n));
        }
    }

    public boolean isPlaying(UUID uuid) {
        MusicPlayEntry rp = this.MUSIC_PLAYERS.get(uuid);
        return rp != null && rp.player() != null && rp.player().isPlaying() || this.pause && this.UNPAUSES_STARTS.stream().anyMatch(m -> m.id().equals(uuid)) || this.pause && rp != null && rp.player().isPaused();
    }

    public void stop() {
        if (!this.reloadFlag) {
            this.stopAllMusicLoad();
            this.stopAllMusicPlayer();
        }
        this.reloadFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        LOGGER.info("Music engine started");
        this.reloading = true;
        HashMap<UUID, MusicReloadEntry> RELOADS = new HashMap<UUID, MusicReloadEntry>();
        Map<UUID, MusicLoadThread> map = this.MUSIC_LOADS;
        synchronized (map) {
            this.MUSIC_LOADS.forEach((n, m) -> RELOADS.put((UUID)n, new MusicReloadEntry(m.getPlaybackInfo(), m.getSource(), m.getPosition(), m.getListener())));
        }
        RELOADS.forEach((n, m) -> this.stopLoadMusicPlayer((UUID)n));
        ArrayList REMOVEMUSICS = new ArrayList();
        Map<UUID, MusicPlayEntry> map2 = this.MUSIC_PLAYERS;
        synchronized (map2) {
            this.MUSIC_PLAYERS.forEach((n, m) -> {
                RELOADS.put((UUID)n, new MusicReloadEntry(m.playbackInfo(), m.player().getMusicSource(), m.player().getPosition(), null));
                REMOVEMUSICS.add(n);
            });
        }
        HashMap LASTTIMES = new HashMap();
        REMOVEMUSICS.forEach(n -> {
            if (this.isPlaying((UUID)n)) {
                LASTTIMES.put(n, System.currentTimeMillis());
            }
            this.stopMusicPlayer((UUID)n);
        });
        RELOADS.forEach((n, m) -> this.loadAddMusicPlayer((UUID)n, m.playbackInfo(), m.source(), m.position(), (result, time, player, retry) -> {
            if (m.listener() != null) {
                m.listener().onResult(result, time, player, retry);
            }
            if (result && LASTTIMES.containsKey(n)) {
                long delay = System.currentTimeMillis() - (Long)LASTTIMES.get(n);
                this.playMusicPlayer((UUID)n, delay);
            }
        }));
        this.reloading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        this.lastTime = System.currentTimeMillis();
        Map<UUID, Object> map = this.MUSIC_PLAYERS;
        synchronized (map) {
            this.REMOVES_PLAYERS.forEach(this::stopMusicPlayer);
            this.REMOVES_PLAYERS.clear();
            this.MUSIC_PLAYERS.forEach((n, m) -> {
                if (m.player().isFinished()) {
                    this.REMOVES_PLAYERS.add((UUID)n);
                    return;
                }
                IMusicTracker tracker = IMPMusicTrackers.createTracker(m.playbackInfo().getTracker(), m.playbackInfo().getTrackerTag());
                if (tracker != null) {
                    Vec3 ps = tracker.getPosition().get();
                    m.player().setCoordinatePosition(ps);
                    m.player().setFixedSound(ps == null);
                }
                m.player().update(m.playbackInfo());
                IMusicSubtitle sub = m.player().getSubtitle();
                if (m.player().isPlaying() && sub != null) {
                    long pos = m.player().getPosition();
                    long lst = this.LAST_SUBTITLE.containsKey(n) ? this.LAST_SUBTITLE.get(n) : 0L;
                    List<SubtitleEntry> subs = sub.getSubtitle(m.player(), m.playbackInfo(), lst, pos);
                    subs.forEach(this::addSubtitle);
                    this.LAST_SUBTITLE.put((UUID)n, pos);
                }
            });
        }
        map = this.MUSIC_LOADS;
        synchronized (map) {
            this.REMOVE_LOADS.forEach(this::stopLoadMusicPlayer);
            this.REMOVE_LOADS.clear();
            this.MUSIC_LOADS.forEach((n, m) -> {
                if (!m.isAlive()) {
                    this.REMOVE_LOADS.add((UUID)n);
                }
            });
        }
        this.lastProsesTime = System.currentTimeMillis() - this.lastTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.pause = true;
        Map<UUID, MusicPlayEntry> map = this.MUSIC_PLAYERS;
        synchronized (map) {
            this.MUSIC_PLAYERS.forEach((n, m) -> {
                if (!m.player().getMusicSource().isLive()) {
                    m.player().pause();
                } else {
                    this.RESTART_LIVES.put((UUID)n, new MusicReloadEntry(m.playbackInfo(), m.player().getMusicSource(), 0L, null));
                    this.REMOVES_PLAYERS.add((UUID)n);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.pause = false;
        Map<UUID, MusicPlayEntry> map = this.MUSIC_PLAYERS;
        synchronized (map) {
            this.MUSIC_PLAYERS.forEach((n, m) -> m.player().unpause());
        }
        this.UNPAUSES_STARTS.forEach(n -> this.playMusicPlayer(n.id(), n.delay()));
        this.UNPAUSES_STARTS.clear();
        this.RESTART_LIVES.forEach((n, m) -> this.loadAddMusicPlayer((UUID)n, m.playbackInfo(), m.source(), 0L, (result, time, player, retry) -> {
            if (result) {
                this.playMusicPlayer((UUID)n, 0L);
            }
        }));
        this.RESTART_LIVES.clear();
        this.RESTART_CHECK.clear();
    }

    public IMusicPlayer getMusicPlayer(UUID uuid) {
        MusicPlayEntry en = this.MUSIC_PLAYERS.get(uuid);
        if (en != null) {
            return this.MUSIC_PLAYERS.get(uuid).player();
        }
        return null;
    }

    public MusicLoadThread getLoadingMusic(UUID uuid) {
        return this.MUSIC_LOADS.get(uuid);
    }

    public void addSubtitle(SubtitleEntry subtitle) {
        ((ClientMusicEvent.SubtitleAdd)ClientMusicEvent.ADD_SUBTITLE.invoker()).add(subtitle);
    }

    public boolean isLoad(UUID musicPlayerId) {
        return this.MUSIC_LOADS.containsKey(musicPlayerId);
    }

    private record UnPauseStartEntry(UUID id, long delay) {
    }

    private record MusicPlayEntry(MusicPlaybackInfo playbackInfo, IMusicPlayer player) {
    }

    private record MusicReloadEntry(MusicPlaybackInfo playbackInfo, MusicSource source, long position, MusicLoadThread.MusicLoadResultListener listener) {
    }
}

