/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.loadertypes;

import dev.felnull.imp.client.gui.screen.monitor.music_manager.SearchMusicMMMonitor;
import dev.felnull.imp.client.music.loadertypes.AbstractLavaPlayerMusicLoaderType;
import dev.felnull.imp.client.music.loadertypes.MusicLoadResult;
import dev.felnull.imp.client.util.LavaPlayerUtil;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.ImageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class YoutubeMusicLoaderType
extends AbstractLavaPlayerMusicLoaderType {
    private static final Component YT_ENTER_TEXT = new TranslatableComponent("imp.text.enterText.youtube");

    public YoutubeMusicLoaderType() {
        super("youtube");
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    public void registerSourceManager(AudioPlayerManager audioPlayerManager) {
        audioPlayerManager.registerSourceManager(new YoutubeAudioSourceManager());
    }

    @Override
    protected ImageInfo createThumbnail(AudioTrack track) {
        return new ImageInfo(ImageInfo.ImageType.YOUTUBE_THUMBNAIL, track.getIdentifier());
    }

    @Override
    public boolean match(AudioTrack track) {
        return track.getSourceManager() instanceof YoutubeAudioSourceManager;
    }

    @Override
    public List<SearchMusicMMMonitor.SearchMusicEntry> search(String name) throws InterruptedException {
        List<AudioTrack> tracks;
        ArrayList<SearchMusicMMMonitor.SearchMusicEntry> musics = new ArrayList<SearchMusicMMMonitor.SearchMusicEntry>();
        try {
            tracks = LavaPlayerUtil.searchYoutube(this.getAudioPlayerManager(), name);
        }
        catch (ExecutionException e) {
            return musics;
        }
        for (AudioTrack track : tracks) {
            MusicLoadResult ret = this.createResult(track);
            musics.add(new SearchMusicMMMonitor.SearchMusicEntry(ret.name(), track.getInfo().author, ret.source(), ret.imageInfo()));
        }
        return musics;
    }

    @Override
    public Component getEnterText() {
        return YT_ENTER_TEXT;
    }
}

