/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.subtitle;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.music.player.IMusicPlayer;
import dev.felnull.imp.client.music.subtitle.IMusicSubtitle;
import dev.felnull.imp.client.music.subtitle.SubtitleEntry;
import dev.felnull.imp.client.music.subtitle.YoutubeSubtitleEnum;
import dev.felnull.imp.client.util.HTMLUtil;
import dev.felnull.imp.client.util.YoutubeUtil;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestSubtitlesDownload;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.Extension;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import dev.felnull.imp.libs.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.Component;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class YoutubeMusicSubtitle
implements IMusicSubtitle {
    private final List<SubtitlesInfo> subtitlesInfos;
    private final List<YSubtitleEntry> subs = new ArrayList<YSubtitleEntry>();
    private final List<YSubtitleEntry> rsubs = new ArrayList<YSubtitleEntry>();
    private final List<SubtitleEntry> currentSubs = new ArrayList<SubtitleEntry>();

    public YoutubeMusicSubtitle(MusicSource source) {
        this.subtitlesInfos = source.isLive() ? List.of() : YoutubeUtil.getSubtitle(source.getIdentifier());
    }

    @Override
    public boolean isExist() {
        return !this.subtitlesInfos.isEmpty();
    }

    @Override
    public void load() throws Exception {
        this.subs.addAll(this.loadSubtitle(this.getSubtitleURL()));
        this.subs.sort((o1, o2) -> Math.toIntExact(o1.st() - o2.st()));
    }

    private URL getSubtitleURL() throws MalformedURLException {
        String lng = IamMusicPlayer.CONFIG.youtubeSubtitleLanguage.getCode();
        if (lng.isEmpty()) {
            lng = OEClientUtil.getGoogleCodeByLanguage((LanguageInfo)Minecraft.m_91087_().m_91102_().m_118983_());
        }
        String urlst = null;
        for (SubtitlesInfo subtitlesInfo : this.subtitlesInfos) {
            if (!subtitlesInfo.getLanguage().equals(lng)) continue;
            urlst = subtitlesInfo.getUrl();
            break;
        }
        if (urlst == null) {
            Optional<SubtitlesInfo> sub = this.subtitlesInfos.stream().filter(n -> n.getLanguage().equals(YoutubeSubtitleEnum.ENGLISH.getCode())).findFirst();
            SubtitlesInfo si = sub.orElseGet(() -> this.subtitlesInfos.get(0));
            RequestSubtitlesDownload request = new RequestSubtitlesDownload(si).formatTo(Extension.TRANSCRIPT_V1).translateTo(lng);
            urlst = request.getDownloadUrl();
        }
        return new URL(urlst);
    }

    private List<YSubtitleEntry> loadSubtitle(URL url) throws ParserConfigurationException, IOException, SAXException {
        ArrayList<YSubtitleEntry> sb = new ArrayList<YSubtitleEntry>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document subDocument = builder.parse(FNURLUtil.getStream(url));
        NodeList subListNL = subDocument.getChildNodes();
        for (int i = 0; i < subListNL.getLength(); ++i) {
            Node node = subListNL.item(i);
            if (!"transcript".equals(node.getNodeName())) continue;
            NodeList nodeList2 = node.getChildNodes();
            for (int k = 0; k < nodeList2.getLength(); ++k) {
                Node node2 = nodeList2.item(k);
                try {
                    NamedNodeMap att = node2.getAttributes();
                    float st = Float.parseFloat(att.getNamedItem("start").getNodeValue());
                    float dr = Float.parseFloat(att.getNamedItem("dur").getNodeValue());
                    String text = node2.getTextContent();
                    for (Component component : YoutubeMusicSubtitle.toComponent(text)) {
                        if (component == null) continue;
                        sb.add(new YSubtitleEntry((long)(st * 1000.0f), (long)(dr * 1000.0f), component));
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return sb;
    }

    private static List<Component> toComponent(String text) {
        String[] txts;
        ArrayList<Component> ls = new ArrayList<Component>();
        for (String txt : txts = text.split("\n")) {
            Component tc;
            if (txt.isEmpty() || (tc = HTMLUtil.toComponent(txt)) == null) continue;
            ls.add(tc);
        }
        return ls;
    }

    @Override
    public List<SubtitleEntry> getSubtitle(IMusicPlayer player, MusicPlaybackInfo playbackInfo, long last, long current) {
        this.currentSubs.clear();
        boolean nu = false;
        for (YSubtitleEntry sub : this.subs) {
            long st = sub.st();
            long ft = sub.st() + sub.dr();
            if (st <= last && ft >= last && st <= current && ft >= current) {
                this.currentSubs.add(new SubtitleEntry(sub.text(), player, playbackInfo, sub.dr()));
                this.rsubs.add(sub);
                nu = true;
                continue;
            }
            if (!nu) continue;
            break;
        }
        this.rsubs.forEach(this.subs::remove);
        this.rsubs.clear();
        return this.currentSubs;
    }

    private record YSubtitleEntry(long st, long dr, Component text) {
    }
}

