/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.tracker;

import dev.felnull.imp.client.music.tracker.EntityMusicTracker;
import dev.felnull.imp.client.music.tracker.FixedMusicTracker;
import dev.felnull.imp.client.music.tracker.IMusicTracker;
import dev.felnull.imp.client.music.tracker.PlayerMusicTracker;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class IMPMusicTrackers {
    private static final Map<ResourceLocation, Function<CompoundTag, IMusicTracker>> TRACKERS = new HashMap<ResourceLocation, Function<CompoundTag, IMusicTracker>>();

    public static void init() {
        IMPMusicTrackers.registerTracker(MusicRingManager.FIXED_TRACKER, FixedMusicTracker::new);
        IMPMusicTrackers.registerTracker(MusicRingManager.ENTITY_TRACKER, EntityMusicTracker::new);
        IMPMusicTrackers.registerTracker(MusicRingManager.PLAYER_TRACKER, PlayerMusicTracker::new);
    }

    public static void registerTracker(ResourceLocation location, Function<CompoundTag, IMusicTracker> tracker) {
        TRACKERS.put(location, tracker);
    }

    public static IMusicTracker createTracker(MusicPlaybackInfo playbackInfo) {
        return IMPMusicTrackers.createTracker(playbackInfo.getTracker(), playbackInfo.getTrackerTag());
    }

    public static IMusicTracker createTracker(ResourceLocation location, CompoundTag tag) {
        if (TRACKERS.containsKey(location)) {
            return TRACKERS.get(location).apply(tag);
        }
        return null;
    }
}

