/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.felnull.imp.block.MusicManagerBlock;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.imp.client.renderer.item.AntennaItemRenderer;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.client.model.SpecialModelLoader;
import dev.felnull.otyacraftengine.client.renderer.blockentity.AbstractBlockEntityRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BoomboxBlockEntityRenderer
extends AbstractBlockEntityRenderer<BoomboxBlockEntity> {
    private static final Map<BoomboxData.MonitorType, BoomboxMonitor> monitors = new HashMap<BoomboxData.MonitorType, BoomboxMonitor>();
    private static final Minecraft mc = Minecraft.m_91087_();

    protected BoomboxBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(BoomboxBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        BlockState state = blockEntity.m_58900_();
        BoomboxData data = blockEntity.getBoomboxData();
        BoomboxBlockEntityRenderer.renderBoombox(poseStack, multiBufferSource, (Direction)state.m_61143_((Property)MusicManagerBlock.FACING), i, j, f, data, data.getHandleRaisedProgress(f) / (float)data.getHandleRaisedMax());
    }

    public static void renderBoombox(PoseStack poseStack, MultiBufferSource multiBufferSource, Direction direction, int i, int j, float f, BoomboxData data, float handleRaised) {
        float lidOpen = data.getLidOpenProgress(f) / (float)data.getLidOpenProgressMax();
        BoomboxData.Buttons buttons = data.getButtons();
        ItemStack cassetteTape = data.getCassetteTape();
        ItemStack antenna = data.getAntenna();
        float parabolicAntennaRoted = data.getParabolicAntennaProgress(f);
        float antennaPar = data.getAntennaProgress(f) / 30.0f;
        boolean changeCassetteTape = data.isChangeCassetteTape();
        ItemStack oldCassetteTape = data.getOldCassetteTape();
        SpecialModelLoader spml = SpecialModelLoader.getInstance();
        VertexConsumer vc = multiBufferSource.m_6299_(Sheets.m_110790_());
        BakedModel handleM = spml.getModel(IMPModels.BOOMBOX_HANDLE);
        BakedModel lidM = spml.getModel(IMPModels.BOOMBOX_LID);
        BakedModel buttonsM = spml.getModel(IMPModels.BOOMBOX_BUTTONS);
        poseStack.m_85836_();
        OERenderUtil.poseRotateDirection((PoseStack)poseStack, (Direction)direction, (int)1);
        if (lidOpen != 0.0f) {
            poseStack.m_85836_();
            OERenderUtil.poseTrans16((PoseStack)poseStack, (double)7.7, (double)3.225, (double)6.0);
            OERenderUtil.poseScaleAll((PoseStack)poseStack, (float)0.72f);
            mc.m_91291_().m_174269_(changeCassetteTape ? oldCassetteTape : cassetteTape, ItemTransforms.TransformType.FIXED, i, j, poseStack, multiBufferSource, 0);
            poseStack.m_85849_();
        }
        BoomboxBlockEntityRenderer.renderAntenna(poseStack, multiBufferSource, i, j, antenna, parabolicAntennaRoted, antennaPar);
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)1.0, (double)8.0, (double)6.0);
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)0.5, (double)0.5, (double)0.5);
        OERenderUtil.poseRotateX((PoseStack)poseStack, (float)((1.0f - handleRaised) * 90.0f));
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)-0.5, (double)-0.5, (double)-0.5);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)handleM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)5.5, (double)1.5, (double)5.0);
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)0.125, (double)0.125, (double)0.125);
        OERenderUtil.poseRotateX((PoseStack)poseStack, (float)(lidOpen * -40.0f));
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)-0.125, (double)-0.125, (double)-0.125);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)lidM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)12.25, (double)9.0, (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)11.25, (double)(9.0 - (buttons.radio() ? 0.5 : 0.0)), (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)10.25, (double)(9.0 - (buttons.start() ? 0.5 : 0.0)), (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)9.25, (double)(9.0 - (buttons.pause() ? 0.5 : 0.0)), (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)8.25, (double)9.0, (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)7.25, (double)(9.0 - (buttons.loop() ? 0.5 : 0.0)), (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)5.55, (double)9.0, (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)4.55, (double)9.0, (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)3.55, (double)(9.0 - (buttons.volMute() ? 0.5 : 0.0)), (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)2.55, (double)(9.0 - (buttons.volMax() ? 0.5 : 0.0)), (double)5.75);
        OERenderUtil.renderModel((PoseStack)poseStack, (VertexConsumer)vc, (BakedModel)buttonsM, (int)i, (int)j);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(1.0, 0.0, 0.0);
        OERenderUtil.poseRotateY((PoseStack)poseStack, (float)180.0f);
        OERenderUtil.poseTrans16((PoseStack)poseStack, (double)0.6, (double)5.6, (double)-4.9);
        BoomboxMonitor monitor = BoomboxBlockEntityRenderer.getMonitor(data.getMonitorType());
        float px16 = 0.0625f;
        monitor.renderAppearance(poseStack, multiBufferSource, 0xF000F0, j, f, px16 * 14.8f, px16 * 2.8f, data);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private static void renderAntenna(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, ItemStack antenna, float roted, float antennaPar) {
        if (!IMPItemUtil.isAntenna(antenna)) {
            return;
        }
        if (antenna.m_150930_(IMPItems.ANTENNA)) {
            poseStack.m_85836_();
            float ws = 0.0125f;
            OERenderUtil.poseTrans16((PoseStack)poseStack, (double)0.25, (double)9.0, (double)10.25);
            poseStack.m_85837_((double)ws, (double)ws, (double)ws);
            OERenderUtil.poseRotateZ((PoseStack)poseStack, (float)90.0f);
            poseStack.m_85837_((double)(-ws), (double)(-ws), (double)(-ws));
            OERenderUtil.poseScaleAll((PoseStack)poseStack, (float)0.75f);
            AntennaItemRenderer.renderAntenna(poseStack, multiBufferSource, i, j, (-0.5f + Math.max(antennaPar, 0.5f)) * 2.0f, -90.0f + 30.0f * Math.min(antennaPar, 0.5f) * 2.0f);
            poseStack.m_85849_();
        } else {
            poseStack.m_85836_();
            OERenderUtil.poseTrans16((PoseStack)poseStack, (double)0.85, (double)8.0, (double)10.1);
            OERenderUtil.poseScaleAll((PoseStack)poseStack, (float)0.72f);
            OERenderUtil.poseRotateX((PoseStack)poseStack, (float)35.0f);
            OERenderUtil.poseRotateZ((PoseStack)poseStack, (float)35.0f);
            OERenderUtil.poseRotateY((PoseStack)poseStack, (float)roted);
            OERenderUtil.poseTrans16((PoseStack)poseStack, (double)0.0, (double)1.3, (double)0.0);
            OERenderUtil.poseRotateX((PoseStack)poseStack, (float)(-30.0f + Math.abs(-0.5f + roted % 120.0f / 120.0f) * 2.0f * 60.0f));
            OERenderUtil.poseTrans16((PoseStack)poseStack, (double)0.0, (double)-1.3, (double)0.0);
            mc.m_91291_().m_174269_(antenna, ItemTransforms.TransformType.GROUND, i, j, poseStack, multiBufferSource, 0);
            poseStack.m_85849_();
        }
    }

    private static BoomboxMonitor getMonitor(BoomboxData.MonitorType type) {
        if (monitors.containsKey((Object)type)) {
            return monitors.get((Object)type);
        }
        BoomboxMonitor monitor = BoomboxMonitor.createdBoomBoxMonitor(type, null);
        monitors.put(type, monitor);
        return monitor;
    }
}

